/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MDDProducer {
    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String dest = MDDProducer.getProperty("jms_dest", "dynamicQueues/JMSBinaryProxy");
        String type = MDDProducer.getProperty("jms_type", "binary");
        String symbol = MDDProducer.getProperty("symbol", "MSFT");
        String price = MDDProducer.getProperty("price", "100.20");
        String market = MDDProducer.getProperty("market", "NYSE");
        MDDProducer app = new MDDProducer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeDouble(MDDProducer.getRandom(1.0, 1.0, true));
        dos.writeUTF(symbol);
        dos.writeDouble(Double.valueOf(price));
        dos.writeUTF(market);
        dos.flush();
        app.sendBytesMessage(dest, bos.toByteArray());
        dos.close();
        bos.close();
    }

    private void sendBytesMessage(String destName, byte[] buffer) throws Exception {
        InitialContext ic = this.getInitialContext();
        QueueConnectionFactory confac = (QueueConnectionFactory)ic.lookup("ConnectionFactory");
        QueueConnection connection = confac.createQueueConnection();
        QueueSession session = connection.createQueueSession(false, 1);
        BytesMessage bm = session.createBytesMessage();
        bm.writeBytes(buffer);
        QueueSender sender = session.createSender((Queue)ic.lookup(destName));
        sender.send((Message)bm);
        sender.close();
        session.close();
        connection.close();
    }

    private InitialContext getInitialContext() throws NamingException {
        Properties env = new Properties();
        if (System.getProperty("java.naming.provider.url") == null) {
            env.put("java.naming.provider.url", "tcp://localhost:61616");
        }
        if (System.getProperty("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        }
        return new InitialContext(env);
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

