/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceHandler;
import org.apache.ws.commons.schema.XmlSchema;

public class PassThroughNHttpGetProcessor
implements HttpGetRequestProcessor {
    private static final Log log = LogFactory.getLog(PassThroughNHttpGetProcessor.class);
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    protected ConfigurationContext cfgCtx;
    protected SourceHandler sourceHandler;

    @Override
    public void init(ConfigurationContext cfgCtx, SourceHandler handler) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.sourceHandler = handler;
    }

    @Override
    public void process(HttpRequest request, HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, boolean isRestDispatching) {
        String uri = request.getRequestLine().getUri();
        String serviceName = this.getServiceName(request);
        HashMap<String, String> parameters = new HashMap<String, String>();
        int pos = uri.indexOf("?");
        if (pos != -1) {
            msgContext.setTo(new EndpointReference(uri.substring(0, pos)));
            StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                pos = param.indexOf("=");
                if (pos != -1) {
                    parameters.put(param.substring(0, pos), param.substring(pos + 1));
                    continue;
                }
                parameters.put(param, null);
            }
        } else {
            msgContext.setTo(new EndpointReference(uri));
        }
        SimpleOutputBuffer outputBuffer = (SimpleOutputBuffer)conn.getContext().getAttribute("synapse.response-source-buffer");
        ContentOutputStream os = new ContentOutputStream((ContentOutputBuffer)outputBuffer);
        if (this.isServiceListBlocked(uri)) {
            this.sendResponseAndFinish(response, 403, conn, (OutputStream)os, msgContext);
        } else if (uri.equals("/favicon.ico")) {
            response.addHeader(LOCATION, "http://ws.apache.org/favicon.ico");
            this.sendResponseAndFinish(response, 301, conn, (OutputStream)os, msgContext);
        } else if (serviceName != null && parameters.containsKey("wsdl")) {
            this.generateWsdl(response, msgContext, conn, (OutputStream)os, serviceName, parameters);
        } else if (serviceName != null && parameters.containsKey("wsdl2")) {
            this.generateWsdl2(response, msgContext, conn, (OutputStream)os, serviceName);
        } else if (serviceName != null && parameters.containsKey("xsd")) {
            this.generateXsd(response, msgContext, conn, (OutputStream)os, serviceName, parameters);
        } else {
            msgContext.setProperty("rest_get_delete_invoke", (Object)true);
        }
    }

    private void sendResponseAndFinish(HttpResponse response, int status, NHttpServerConnection conn, OutputStream os, MessageContext msgContext) {
        response.setStatusCode(status);
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.GET_REQUEST_COMPLETE);
        this.sourceHandler.commitResponseHideExceptions(conn, response);
        this.closeOutputStream(os);
        msgContext.setProperty("GET_REQUEST_HANDLED", (Object)Boolean.TRUE);
    }

    private void sendResponseAndFinish(HttpResponse response, byte[] data, NHttpServerConnection conn, OutputStream os, MessageContext msgContext) throws IOException {
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.GET_REQUEST_COMPLETE);
        this.sourceHandler.commitResponseHideExceptions(conn, response);
        this.write(conn, os, data);
        this.closeOutputStream(os);
        msgContext.setProperty("GET_REQUEST_HANDLED", (Object)Boolean.TRUE);
    }

    private void closeOutputStream(OutputStream os) {
        try {
            os.flush();
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void generateWsdl(HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String serviceName, Map<String, String> parameters) {
        AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
        if (service != null) {
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                String parameterValue = parameters.get("wsdl");
                if (parameterValue == null) {
                    service.printWSDL((OutputStream)output, PassThroughNHttpGetProcessor.getIpAddress());
                } else {
                    service.printUserWSDL((OutputStream)output, parameterValue);
                }
                response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.sendResponseAndFinish(response, output.toByteArray(), conn, os, msgContext);
            }
            catch (Exception e) {
                this.handleBrowserException(response, msgContext, conn, os, "Error generating ?wsdl output for service : " + serviceName, e);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find service: " + serviceName + " for WSDL generation."));
            }
            msgContext.setProperty("rest_get_delete_invoke", (Object)true);
        }
    }

    protected void generateWsdl2(HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String serviceName) {
        AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
        if (service != null) {
            String parameterValue = (String)service.getParameterValue("serviceType");
            if ("proxy".equals(parameterValue) && !this.isWSDLProvidedForProxyService(service)) {
                this.handleBrowserException(response, msgContext, conn, os, "No WSDL was provided for the Service " + serviceName + ". A WSDL cannot be generated.", null);
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                service.printWSDL2((OutputStream)output, PassThroughNHttpGetProcessor.getIpAddress());
                response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.sendResponseAndFinish(response, output.toByteArray(), conn, os, msgContext);
            }
            catch (Exception e) {
                this.handleBrowserException(response, msgContext, conn, os, "Error generating ?wsdl2 output for service : " + serviceName, e);
            }
        } else {
            msgContext.setProperty("rest_get_delete_invoke", (Object)true);
        }
    }

    protected String getServiceName(HttpRequest request) {
        int opnStart;
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = null;
        if (uri.startsWith(servicePath)) {
            serviceName = uri.substring(servicePath.length());
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            if (serviceName.contains("?")) {
                serviceName = serviceName.substring(0, serviceName.indexOf("?"));
            }
        } else {
            String incomingURI = request.getRequestLine().getUri();
            Map serviceURIMap = (Map)this.cfgCtx.getProperty("service.epr.map");
            if (serviceURIMap != null) {
                Set keySet = serviceURIMap.keySet();
                for (Object key : keySet) {
                    if (!incomingURI.toLowerCase().contains(((String)key).toLowerCase())) continue;
                    return (String)serviceURIMap.get(key);
                }
            }
        }
        if (serviceName != null && (opnStart = serviceName.indexOf("/")) != -1) {
            serviceName = serviceName.substring(0, opnStart);
        }
        return serviceName;
    }

    protected void generateXsd(HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String serviceName, Map<String, String> parameters) {
        if (parameters.get("xsd") == null || "".equals(parameters.get("xsd"))) {
            AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    service.printSchema((OutputStream)output);
                    response.addHeader(CONTENT_TYPE, TEXT_XML);
                    this.sendResponseAndFinish(response, output.toByteArray(), conn, os, msgContext);
                }
                catch (Exception e) {
                    this.handleBrowserException(response, msgContext, conn, os, "Error generating ?xsd output for service : " + serviceName, e);
                }
            } else {
                msgContext.setProperty("rest_get_delete_invoke", (Object)true);
            }
        } else {
            String schemaName = parameters.get("xsd");
            AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                int dotIndex;
                service.populateSchemaMappings();
                Map schemaTable = service.getSchemaMappingTable();
                XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                    String schemaKey = schemaName.substring(0, dotIndex);
                    schema = (XmlSchema)schemaTable.get(schemaKey);
                }
                if (schema != null) {
                    try {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        schema.write((OutputStream)output);
                        response.addHeader(CONTENT_TYPE, TEXT_XML);
                        this.sourceHandler.commitResponseHideExceptions(conn, response);
                        this.write(conn, os, output.toByteArray());
                        this.closeOutputStream(os);
                        msgContext.setProperty("GET_REQUEST_HANDLED", (Object)Boolean.TRUE);
                    }
                    catch (Exception e) {
                        this.handleBrowserException(response, msgContext, conn, os, "Error generating named ?xsd output for service : " + serviceName, e);
                    }
                } else {
                    response.setStatusCode(404);
                    this.closeOutputStream(os);
                    msgContext.setProperty("GET_REQUEST_HANDLED", (Object)Boolean.TRUE);
                }
            } else {
                msgContext.setProperty("rest_get_delete_invoke", (Object)true);
            }
        }
    }

    protected void handleBrowserException(HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (!response.containsHeader("Transfer-Encoding")) {
            response.setStatusCode(500);
            response.setReasonPhrase(msg);
            response.addHeader(CONTENT_TYPE, TEXT_HTML);
            this.sourceHandler.commitResponseHideExceptions(conn, response);
            try {
                this.write(conn, os, msg.getBytes());
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        msgContext.setProperty("GET_REQUEST_HANDLED", (Object)Boolean.TRUE);
    }

    protected boolean isServiceListBlocked(String incomingURI) {
        String isBlocked = NHttpConfiguration.getInstance().isServiceListBlocked();
        return ("/services".equals(incomingURI) || "/services/".equals(incomingURI)) && Boolean.parseBoolean(isBlocked);
    }

    protected boolean isWSDLProvidedForProxyService(AxisService service) {
        boolean isWSDLProvided = false;
        if (service.getParameterValue("wsdl4jDefinition") != null || service.getParameterValue("WSDL20Description") != null) {
            isWSDLProvided = true;
        }
        return isWSDLProvided;
    }

    protected static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !PassThroughNHttpGetProcessor.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    protected static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(NHttpServerConnection conn, OutputStream os, byte[] data) throws IOException {
        HttpContext httpContext = conn.getContext();
        synchronized (httpContext) {
            os.write(data);
        }
    }
}

