/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Unary
extends Lop {
    private OperationTypes operation;
    private Lop valInput;
    private int _numThreads = 1;

    public Unary(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.UNARY, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.valInput = input1.getDataType() == Expression.DataType.MATRIX ? input2 : input1;
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.ANY);
            this.lps.removeNonPiggybackableJobs();
            this.lps.removeCompatibility(JobType.CM_COV);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapOrReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public Unary(Lop input1, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int numThreads) {
        super(Lop.Type.UNARY, dt, vt);
        this.init(input1, op, dt, vt, et);
        this._numThreads = numThreads;
    }

    private void init(Lop input1, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        if (!(op != OperationTypes.INVERSE && op != OperationTypes.CHOLESKY || et != LopProperties.ExecType.SPARK && et != LopProperties.ExecType.MR)) {
            throw new LopsException("Invalid exection type " + et.toString() + " for operation " + op.toString());
        }
        this.operation = op;
        this.valInput = null;
        this.addInput(input1);
        input1.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.ANY);
            this.lps.removeNonPiggybackableJobs();
            this.lps.removeCompatibility(JobType.CM_COV);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapOrReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        if (this.valInput != null) {
            return "Operation: " + (Object)((Object)this.operation) + " Label: " + this.valInput.getOutputParameters().getLabel() + " input types " + this.getInputs().get(0).toString() + " " + this.getInputs().get(1).toString();
        }
        return "Operation: " + (Object)((Object)this.operation) + " Label: N/A";
    }

    private String getOpcode() {
        return Unary.getOpcode(this.operation);
    }

    public static String getOpcode(OperationTypes op) {
        switch (op) {
            case NOT: {
                return "!";
            }
            case ABS: {
                return "abs";
            }
            case SIN: {
                return "sin";
            }
            case COS: {
                return "cos";
            }
            case TAN: {
                return "tan";
            }
            case ASIN: {
                return "asin";
            }
            case ACOS: {
                return "acos";
            }
            case ATAN: {
                return "atan";
            }
            case SINH: {
                return "sinh";
            }
            case COSH: {
                return "cosh";
            }
            case TANH: {
                return "tanh";
            }
            case SIGN: {
                return "sign";
            }
            case SQRT: {
                return "sqrt";
            }
            case EXP: {
                return "exp";
            }
            case LOG: {
                return "log";
            }
            case LOG_NZ: {
                return "log_nz";
            }
            case ROUND: {
                return "round";
            }
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case SUBTRACT_NZ: {
                return "-nz";
            }
            case SUBTRACTRIGHT: {
                return "s-r";
            }
            case MULTIPLY: {
                return "*";
            }
            case MULTIPLY2: {
                return "*2";
            }
            case MINUS1_MULTIPLY: {
                return "1-*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%%";
            }
            case INTDIV: {
                return "%/%";
            }
            case Over: {
                return "so";
            }
            case POW: {
                return "^";
            }
            case POW2: {
                return "^2";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "<=";
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case MAX: {
                return "max";
            }
            case MIN: {
                return "min";
            }
            case CEIL: {
                return "ceil";
            }
            case FLOOR: {
                return "floor";
            }
            case CUMSUM: {
                return "ucumk+";
            }
            case CUMPROD: {
                return "ucum*";
            }
            case CUMMIN: {
                return "ucummin";
            }
            case CUMMAX: {
                return "ucummax";
            }
            case CUMSUMPROD: {
                return "ucumk+*";
            }
            case INVERSE: {
                return "inverse";
            }
            case CHOLESKY: {
                return "cholesky";
            }
            case MR_IQM: {
                return "qpick";
            }
            case SPROP: {
                return "sprop";
            }
            case SIGMOID: {
                return "sigmoid";
            }
            case CAST_AS_MATRIX: {
                return "castdtm";
            }
            case CAST_AS_FRAME: {
                return "castdtf";
            }
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case XOR: {
                return "xor";
            }
            case BW_AND: {
                return "bitwAnd";
            }
            case BW_OR: {
                return "bitwOr";
            }
            case BW_XOR: {
                return "bitwXor";
            }
            case BW_SHIFTL: {
                return "bitwShiftL";
            }
            case BW_SHIFTR: {
                return "bitwShiftR";
            }
        }
        throw new LopsException("Instruction not defined for Unary operation: " + (Object)((Object)op));
    }

    public static boolean isMultiThreadedOp(OperationTypes op) {
        return op == OperationTypes.CUMSUM || op == OperationTypes.CUMPROD || op == OperationTypes.CUMMIN || op == OperationTypes.CUMMAX || op == OperationTypes.CUMSUMPROD || op == OperationTypes.EXP || op == OperationTypes.LOG || op == OperationTypes.SIGMOID;
    }

    @Override
    public String getInstructions(String input1, String output) {
        if (this.getInputs().size() != 1) {
            throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for an Unary opration: " + (Object)((Object)this.operation));
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP && Unary.isMultiThreadedOp(this.operation)) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        if (this.getInputs().get(0).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(0).prepInputOperand(input1));
        }
        sb.append("\u00b0");
        if (this.getInputs().get(1).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int inputIndex1, int inputIndex2, int outputIndex) {
        if (this.getInputs().size() == 2) {
            Lop linput1 = this.getInputs().get(0);
            Lop linput2 = this.getInputs().get(1);
            int scalarIndex = -1;
            int matrixIndex = -1;
            String matrixLabel = null;
            if (linput1.getDataType() == Expression.DataType.MATRIX) {
                scalarIndex = 1;
                matrixLabel = String.valueOf(inputIndex1);
            } else {
                scalarIndex = 0;
                matrixLabel = String.valueOf(inputIndex2);
                if (this.operation == OperationTypes.SUBTRACT) {
                    this.operation = OperationTypes.SUBTRACTRIGHT;
                } else if (this.operation == OperationTypes.DIVIDE) {
                    this.operation = OperationTypes.Over;
                }
            }
            matrixIndex = 1 - scalarIndex;
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.getExecType());
            sb.append("\u00b0");
            sb.append(this.getOpcode());
            sb.append("\u00b0");
            if (this.operation == OperationTypes.INTDIV || this.operation == OperationTypes.MODULUS || this.operation == OperationTypes.POW || this.operation == OperationTypes.GREATER_THAN || this.operation == OperationTypes.GREATER_THAN_OR_EQUALS || this.operation == OperationTypes.LESS_THAN || this.operation == OperationTypes.LESS_THAN_OR_EQUALS || this.operation == OperationTypes.EQUALS || this.operation == OperationTypes.NOT_EQUALS) {
                sb.append(linput1.getDataType() == Expression.DataType.MATRIX ? linput1.prepInputOperand(String.valueOf(inputIndex1)) : linput1.prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
                sb.append(linput2.getDataType() == Expression.DataType.MATRIX ? linput2.prepInputOperand(String.valueOf(inputIndex2)) : linput2.prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
            } else {
                sb.append(this.getInputs().get(matrixIndex).prepInputOperand(matrixLabel));
                sb.append("\u00b0");
                sb.append(this.getInputs().get(scalarIndex).prepScalarInputOperand(this.getExecType()));
                sb.append("\u00b0");
            }
            sb.append(this.prepOutputOperand(outputIndex));
            return sb.toString();
        }
        throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for an Unary opration: " + (Object)((Object)this.operation));
    }

    public static enum OperationTypes {
        ADD,
        SUBTRACT,
        SUBTRACTRIGHT,
        MULTIPLY,
        MULTIPLY2,
        DIVIDE,
        MODULUS,
        INTDIV,
        MINUS1_MULTIPLY,
        POW,
        POW2,
        LOG,
        MAX,
        MIN,
        NOT,
        ABS,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        SINH,
        COSH,
        TANH,
        SIGN,
        SQRT,
        EXP,
        Over,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        AND,
        OR,
        XOR,
        BW_AND,
        BW_OR,
        BW_XOR,
        BW_SHIFTL,
        BW_SHIFTR,
        ROUND,
        CEIL,
        FLOOR,
        MR_IQM,
        INVERSE,
        CHOLESKY,
        CUMSUM,
        CUMPROD,
        CUMMIN,
        CUMMAX,
        CUMSUMPROD,
        SPROP,
        SIGMOID,
        SUBTRACT_NZ,
        LOG_NZ,
        CAST_AS_MATRIX,
        CAST_AS_FRAME,
        NOTSUPPORTED;

    }
}

