/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.lops.LeftIndex;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.FrameIndexingSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixIndexingSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;

public abstract class IndexingSPInstruction
extends UnarySPInstruction {
    protected CPOperand rowLower;
    protected CPOperand rowUpper;
    protected CPOperand colLower;
    protected CPOperand colUpper;
    protected AggBinaryOp.SparkAggType _aggType = null;

    protected IndexingSPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, AggBinaryOp.SparkAggType aggtype, String opcode, String istr) {
        super(SPInstruction.SPType.MatrixIndexing, null, in, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
        this._aggType = aggtype;
    }

    protected IndexingSPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.MatrixIndexing, null, lhsInput, rhsInput, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    public static IndexingSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 8) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                AggBinaryOp.SparkAggType aggtype = AggBinaryOp.SparkAggType.valueOf(parts[7]);
                if (in.getDataType() == Expression.DataType.MATRIX) {
                    return new MatrixIndexingSPInstruction(in, rl, ru, cl, cu, out, aggtype, opcode, str);
                }
                return new FrameIndexingSPInstruction(in, rl, ru, cl, cu, out, aggtype, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (opcode.equalsIgnoreCase("leftIndex") || opcode.equalsIgnoreCase("mapLeftIndex")) {
            if (parts.length == 9) {
                CPOperand lhsInput = new CPOperand(parts[1]);
                CPOperand rhsInput = new CPOperand(parts[2]);
                CPOperand rl = new CPOperand(parts[3]);
                CPOperand ru = new CPOperand(parts[4]);
                CPOperand cl = new CPOperand(parts[5]);
                CPOperand cu = new CPOperand(parts[6]);
                CPOperand out = new CPOperand(parts[7]);
                LeftIndex.LixCacheType lixtype = LeftIndex.LixCacheType.valueOf(parts[8]);
                if (lhsInput.getDataType() == Expression.DataType.MATRIX) {
                    return new MatrixIndexingSPInstruction(lhsInput, rhsInput, rl, ru, cl, cu, out, lixtype, opcode, str);
                }
                return new FrameIndexingSPInstruction(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a IndexingSPInstruction: " + str);
    }
}

