/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.FastBufferedDataInputStream;
import org.apache.sysml.runtime.util.FastBufferedDataOutputStream;

public class BinaryBlockSerialization
implements Serialization {
    public boolean accept(Class arg0) {
        boolean ret = false;
        if (arg0 == MatrixBlock.class) {
            ret = true;
        }
        return ret;
    }

    public Deserializer<MatrixBlock> getDeserializer(Class arg0) {
        return new MatrixBlockDeserializer();
    }

    public Serializer<MatrixBlock> getSerializer(Class arg0) {
        return new MatrixBlockSerializer();
    }

    public static class MatrixBlockSerializer
    implements Serializer<MatrixBlock> {
        private FastBufferedDataOutputStream _out = null;

        public void open(OutputStream arg0) throws IOException {
            this._out = new FastBufferedDataOutputStream(arg0);
        }

        public void serialize(MatrixBlock mb) throws IOException {
            mb.write(this._out);
            this._out.flush();
        }

        public void close() throws IOException {
            IOUtilFunctions.closeSilently(this._out);
        }
    }

    public static class MatrixBlockDeserializer
    implements Deserializer<MatrixBlock> {
        private FastBufferedDataInputStream _in = null;
        private MatrixBlock _buff = null;

        public void open(InputStream arg0) throws IOException {
            this._in = new FastBufferedDataInputStream(arg0);
        }

        public MatrixBlock deserialize(MatrixBlock mb) throws IOException {
            if (mb == null) {
                if (this._buff == null) {
                    this._buff = new MatrixBlock();
                }
                mb = this._buff;
            }
            mb.readFields(this._in);
            return mb;
        }

        public void close() throws IOException {
            IOUtilFunctions.closeSilently(this._in);
        }
    }
}

