/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.kmeans_predict.Get_best_assignments_output;

public class Kmeans_predict
extends Script {
    public Kmeans_predict() {
        String string = "scripts/algorithms/Kmeans-predict.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Get_best_assignments_output get_best_assignments(Object object) {
        String string = "source('scripts/algorithms/Kmeans-predict.dml') as mlcontextns;[row_ids, col_ids, margins, max_counts, rounded_percentages] = mlcontextns::get_best_assignments(counts);";
        Script script = new Script(string);
        script.in("counts", object).out("row_ids").out("col_ids").out("margins").out("max_counts").out("rounded_percentages");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("row_ids");
        Matrix matrix2 = mLResults.getMatrix("col_ids");
        Matrix matrix3 = mLResults.getMatrix("margins");
        Matrix matrix4 = mLResults.getMatrix("max_counts");
        Matrix matrix5 = mLResults.getMatrix("rounded_percentages");
        Get_best_assignments_output get_best_assignments_output = new Get_best_assignments_output(matrix, matrix2, matrix3, matrix4, matrix5);
        return get_best_assignments_output;
    }

    public String get_best_assignments__docs() {
        String string = "get_best_assignments = function (Matrix[double] counts)\nreturn (Matrix[double] row_ids, Matrix[double] col_ids, Matrix[double] margins, \n        Matrix[double] max_counts, Matrix[double] rounded_percentages)\n{\n    margins = rowSums (counts);\n    select_positive = removeEmpty (target = diag (margins > 0), margin = \"rows\");\n    row_ids = select_positive %*% seq (1, nrow (margins), 1);\n    pos_counts = select_positive %*% counts;\n    pos_margins = select_positive %*% margins;\n    max_counts = rowMaxs (pos_counts);\n    is_max_count = (pos_counts == max_counts);\n    aggr_is_max_count = t(cumsum (t(is_max_count)));\n    col_ids = rowSums (aggr_is_max_count == 0) + 1;\n    rounded_percentages = round (1000000.0 * max_counts / pos_margins) / 10000.0;\n}\n";
        return string;
    }

    public String get_best_assignments__source() {
        String string = "get_best_assignments = function (Matrix[double] counts)\nreturn (Matrix[double] row_ids, Matrix[double] col_ids, Matrix[double] margins, \n        Matrix[double] max_counts, Matrix[double] rounded_percentages)\n{\n    margins = rowSums (counts);\n    select_positive = removeEmpty (target = diag (margins > 0), margin = \"rows\");\n    row_ids = select_positive %*% seq (1, nrow (margins), 1);\n    pos_counts = select_positive %*% counts;\n    pos_margins = select_positive %*% margins;\n    max_counts = rowMaxs (pos_counts);\n    is_max_count = (pos_counts == max_counts);\n    aggr_is_max_count = t(cumsum (t(is_max_count)));\n    col_ids = rowSums (aggr_is_max_count == 0) + 1;\n    rounded_percentages = round (1000000.0 * max_counts / pos_margins) / 10000.0;\n}\n";
        return string;
    }
}

