/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.max_pool2d.Forward_output;

public class Max_pool2d
extends Script {
    public Max_pool2d() {
        String string = "scripts/nn/layers/max_pool2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        String string = "source('scripts/nn/layers/max_pool2d.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("X", object).in("C", object2).in("Hin", object3).in("Win", object4).in("Hf", object5).in("Wf", object6).in("strideh", object7).in("stridew", object8).in("padh", object9).in("padw", object10).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * This implementation uses `im2col` internally for each image to\n   * extract local image regions (patches) of each channel slice into\n   * columns, and then performs max pooling over the patches to compute\n   * the output maps.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * This implementation uses `im2col` internally for each image to\n   * extract local image regions (patches) of each channel slice into\n   * columns, and then performs max pooling over the patches to compute\n   * the output maps.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  Hout = as.integer(floor((Hin + 2*padh - Hf)/strideh + 1))\n  Wout = as.integer(floor((Win + 2*padw - Wf)/stridew + 1))\n  pad_value = -1/0  # in max pooling we pad with -infinity\n\n  # Create output volume\n  out = matrix(0, rows=N, cols=C*Hout*Wout)\n\n  # Max pooling - im2col implementation\n  parfor (n in 1:N) {  # all examples\n    img = matrix(X[n,], rows=C, cols=Hin*Win)  # reshape\n\n    if (padh > 0 | padw > 0) {\n      # Pad image to shape (C, (Hin+2*padh)*(Win+2*padw))\n      img = util::pad_image(img, Hin, Win, padh, padw, pad_value)\n    }\n\n    img_maxes = matrix(0, rows=C, cols=Hout*Wout)  # zeros\n    parfor (c in 1:C) {  # all channels\n      # Extract local image slice patches into columns with im2col, of shape (Hf*Wf, Hout*Wout)\n      img_slice_cols = util::im2col(img[c,], Hin+2*padh, Win+2*padw, Hf, Wf, strideh, stridew)\n\n      # Max pooling on patches\n      img_maxes[c,] = colMaxs(img_slice_cols)\n    }\n\n    out[n,] = matrix(img_maxes, rows=1, cols=C*Hout*Wout)\n  }\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) {
        String string = "source('scripts/nn/layers/max_pool2d.dml') as mlcontextns;dX = mlcontextns::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("C", object5).in("Hin", object6).in("Win", object7).in("Hf", object8).in("Wf", object9).in("strideh", object10).in("stridew", object11).in("padh", object12).in("padw", object13).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout, matrix[double] X,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Input data matrix, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout, matrix[double] X,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Input data matrix, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   */\n  N = nrow(X)\n  pad_value = -1/0  # in max pooling we pad with -infinity\n\n  # Create gradient volume\n  dX = matrix(0, rows=N, cols=C*Hin*Win)\n\n  # Gradient of max pooling\n  parfor (n in 1:N, check=0) {  # all examples\n    img = matrix(X[n,], rows=C, cols=Hin*Win)\n    if (padh > 0 | padw > 0) {\n      # Pad image to shape (C, (Hin+2*padh)*(Win+2*padw))\n      img = util::pad_image(img, Hin, Win, padh, padw, pad_value)\n    }\n\n    dimg = matrix(0, rows=C, cols=(Hin+2*padh)*(Win+2*padw))\n    parfor (c in 1:C, check=0) {  # all channels\n      img_slice = matrix(img[c,], rows=Hin+2*padh, cols=Win+2*padw)\n      dimg_slice = matrix(0, rows=Hin+2*padh, cols=Win+2*padw)\n      for (hout in 1:Hout, check=0) {  # all output rows\n        hin = (hout-1)*strideh + 1\n        for (wout in 1:Wout) {  # all output columns\n          win = (wout-1)*stridew + 1\n          img_slice_patch = img_slice[hin:hin+Hf-1, win:win+Wf-1]\n          max_val_ind = img_slice_patch == max(img_slice_patch)  # max value indicator matrix\n          # gradient passes through only for the max value(s) in this patch\n          dimg_slice_patch = max_val_ind * dout[n, (c-1)*Hout*Wout + (hout-1)*Wout + wout]\n          dimg_slice[hin:hin+Hf-1, win:win+Wf-1] = dimg_slice[hin:hin+Hf-1, win:win+Wf-1]\n                                                   + dimg_slice_patch\n        }\n      }\n      dimg[c,] = matrix(dimg_slice, rows=1, cols=(Hin+2*padh)*(Win+2*padw))\n    }\n\n    if (padh > 0 | padw > 0) {\n      # Unpad image gradient\n      dimg = util::unpad_image(dimg, Hin, Win, padh, padw)  # shape (C, (Hin+2*padh)*(Win+2*padw))\n    }\n    dX[n,] = matrix(dimg, rows=1, cols=C*Hin*Win)\n  }\n}\n";
        return string;
    }
}

