/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.optim.sgd_nesterov.Update_output;

public class Sgd_nesterov
extends Script {
    public Sgd_nesterov() {
        String string = "scripts/nn/optim/sgd_nesterov.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix init(Object object) {
        String string = "source('scripts/nn/optim/sgd_nesterov.dml') as mlcontextns;v = mlcontextns::init(X);";
        Script script = new Script(string);
        script.in("X", object).out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("v");
        return matrix;
    }

    public String init__docs() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - v: Initial velocity of the parameters `X`.\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - v: Initial velocity of the parameters `X`.\n   */\n  v = matrix(0, rows=nrow(X), cols=ncol(X))\n}\n";
        return string;
    }

    public Update_output update(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/optim/sgd_nesterov.dml') as mlcontextns;[X, v] = mlcontextns::update(X, dX, lr, mu, v);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).in("mu", object4).in("v", object5).out("X").out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Matrix matrix2 = mLResults.getMatrix("v");
        Update_output update_output = new Update_output(matrix, matrix2);
        return update_output;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double mu, matrix[double] v)\n    return (matrix[double] X, matrix[double] v) {\n  /*\n   * Performs an SGD update with Nesterov momentum.\n   *\n   * As with regular SGD with momentum, in SGD with Nesterov momentum,\n   * we assume that the parameters have a velocity that continues\n   * with some momentum, and that is influenced by the gradient.\n   * In this view specifically, we perform the position update from the\n   * position that the momentum is about to carry the parameters to,\n   * rather than from the previous position.  Additionally, we always\n   * store the parameters in their position after momentum.\n   *\n   * Reference:\n   *  - Advances in optimizing Recurrent Networks, Bengio et al.,\n   *    section 3.5.\n   *    - http://arxiv.org/abs/1212.0901\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - mu: Momentum value.\n   *      Typical values are in the range of [0.5, 0.99], usually\n   *      started at the lower end and annealed towards the higher end.\n   *  - v: State maintaining the velocity of the parameters `X`, of same\n   *      shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters X, of same shape as input X.\n   *  - v: Updated velocity of the parameters X, of same shape as\n   *      input v.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double mu, matrix[double] v)\n    return (matrix[double] X, matrix[double] v) {\n  /*\n   * Performs an SGD update with Nesterov momentum.\n   *\n   * As with regular SGD with momentum, in SGD with Nesterov momentum,\n   * we assume that the parameters have a velocity that continues\n   * with some momentum, and that is influenced by the gradient.\n   * In this view specifically, we perform the position update from the\n   * position that the momentum is about to carry the parameters to,\n   * rather than from the previous position.  Additionally, we always\n   * store the parameters in their position after momentum.\n   *\n   * Reference:\n   *  - Advances in optimizing Recurrent Networks, Bengio et al.,\n   *    section 3.5.\n   *    - http://arxiv.org/abs/1212.0901\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - mu: Momentum value.\n   *      Typical values are in the range of [0.5, 0.99], usually\n   *      started at the lower end and annealed towards the higher end.\n   *  - v: State maintaining the velocity of the parameters `X`, of same\n   *      shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters X, of same shape as input X.\n   *  - v: Updated velocity of the parameters X, of same shape as\n   *      input v.\n   */\n  v_prev = v\n  v = mu*v - lr*dX  # update velocity\n  X = X - mu*v_prev + (1+mu)*v  # update position, including momentum\n}\n";
        return string;
    }
}

