/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;

public class JMLCUtils {
    public static void cleanupRuntimeProgram(Program prog, String[] outputs) {
        HashMap<String, FunctionProgramBlock> funcMap = prog.getFunctionProgramBlocks();
        HashSet<String> blacklist = new HashSet<String>(Arrays.asList(outputs));
        if (funcMap != null && !funcMap.isEmpty()) {
            for (Map.Entry entry : funcMap.entrySet()) {
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    JMLCUtils.rCleanupRuntimeProgram(pb, blacklist);
                }
            }
        }
        for (ProgramBlock programBlock : prog.getProgramBlocks()) {
            JMLCUtils.rCleanupRuntimeProgram(programBlock, blacklist);
        }
    }

    public static void rCleanupRuntimeProgram(ProgramBlock pb, HashSet<String> outputs) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
            for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else {
            pb.setInstructions(JMLCUtils.cleanupRuntimeInstructions(pb.getInstructions(), outputs));
        }
    }

    public static ArrayList<Instruction> cleanupRuntimeInstructions(ArrayList<Instruction> insts, String ... outputs) {
        return JMLCUtils.cleanupRuntimeInstructions(insts, new HashSet<String>(Arrays.asList(outputs)));
    }

    public static ArrayList<Instruction> cleanupRuntimeInstructions(ArrayList<Instruction> insts, HashSet<String> outputs) {
        ArrayList<Instruction> ret = new ArrayList<Instruction>();
        for (Instruction inst : insts) {
            if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isRemoveVariable()) {
                ArrayList<String> currRmVar = new ArrayList<String>();
                for (CPOperand input : ((VariableCPInstruction)inst).getInputs()) {
                    if (outputs.contains(input.getName())) continue;
                    currRmVar.add(input.getName());
                }
                if (currRmVar.isEmpty()) continue;
                ret.add(VariableCPInstruction.prepareRemoveInstruction(currRmVar.toArray(new String[0])));
                continue;
            }
            ret.add(inst);
        }
        return ret;
    }
}

