/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class WhileProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private ArrayList<Instruction> _exitInstructions;
    private ArrayList<ProgramBlock> _childBlocks;

    public WhileProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._exitInstructions = new ArrayList();
        this._childBlocks = new ArrayList();
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public void setExitInstructions2(ArrayList<Instruction> exitInstructions) {
        this._exitInstructions = exitInstructions;
    }

    public void setExitInstructions1(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    public ArrayList<Instruction> getExitInstructions() {
        return this._exitInstructions;
    }

    private BooleanObject executePredicate(ExecutionContext ec) {
        BooleanObject result = null;
        try {
            if (this._sb != null) {
                if (DMLScript.isActiveAM()) {
                    DMLAppMasterUtils.setupProgramBlockRemoteMaxMemory(this);
                }
                WhileStatementBlock wsb = (WhileStatementBlock)this._sb;
                Hop predicateOp = wsb.getPredicateHops();
                boolean recompile = wsb.requiresPredicateRecompilation();
                result = (BooleanObject)this.executePredicate(this._predicate, predicateOp, recompile, Expression.ValueType.BOOLEAN, ec);
            } else {
                result = (BooleanObject)this.executePredicate(this._predicate, null, false, Expression.ValueType.BOOLEAN, ec);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the while predicate.", ex);
        }
        return result;
    }

    @Override
    public void execute(ExecutionContext ec) {
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            while (this.executePredicate(ec).getBooleanValue()) {
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    ec.updateDebugState(i);
                    this._childBlocks.get(i).execute(ec);
                }
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating while program block", e);
        }
        try {
            this.executeInstructions(this._exitInstructions, ec);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error executing while exit instructions.", e);
        }
    }

    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    public void setChildBlocks(ArrayList<ProgramBlock> childs) {
        this._childBlocks = childs;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in while program block generated from while statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

