/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn.ropt;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.yarn.ropt.YarnOptimizerUtils;

public class ResourceConfig {
    private long _cpres = -1L;
    private ArrayList<Long> _mrres = null;

    public ResourceConfig(long cp, ArrayList<Long> mr) {
        this._cpres = cp;
        this._mrres = mr;
    }

    public ResourceConfig(ArrayList<ProgramBlock> prog, long init) {
        this._cpres = init;
        this._mrres = new ArrayList();
        this.addProgramBlocks(prog, init);
    }

    public long getCPResource() {
        return this._cpres;
    }

    public void setCPResource(long res) {
        this._cpres = res;
    }

    public long getMRResources(int i) {
        if (this._mrres.size() <= i) {
            throw new DMLRuntimeException("Memo table out-of-bounds: " + this._mrres.size() + " vs " + i);
        }
        return this._mrres.get(i);
    }

    public double[][] getMRResourcesMemo() {
        int len = this._mrres.size();
        double[][] ret = new double[len][2];
        for (int i = 0; i < len; ++i) {
            ret[i][0] = this._mrres.get(i).longValue();
            ret[i][1] = -1.0;
        }
        return ret;
    }

    public void setMRResources(ArrayList<ProgramBlock> B, double[][] res) {
        if (this._mrres.size() != res.length) {
            throw new DMLRuntimeException("Memo table sizes do not match: " + this._mrres.size() + " vs " + res.length);
        }
        int len = res.length;
        for (int i = 0; i < len; ++i) {
            this._mrres.set(i, (long)res[i][0]);
        }
    }

    public long getMaxMRResource() {
        double val = Collections.max(this._mrres).longValue();
        return (long)val;
    }

    public String serialize() {
        StringBuilder ret = new StringBuilder();
        ret.append(YarnOptimizerUtils.toMB(this._cpres));
        ret.append(",");
        int len = this._mrres.size();
        for (int i = 0; i < len - 1; ++i) {
            ret.append(YarnOptimizerUtils.toMB(this._mrres.get(i)));
            ret.append(",");
        }
        ret.append(YarnOptimizerUtils.toMB(this._mrres.get(len - 1)));
        return ret.toString();
    }

    public static ResourceConfig deserialize(String str) {
        String[] parts = str.split(",");
        long cp = YarnOptimizerUtils.toB(Long.valueOf(parts[0]));
        ArrayList<Long> mr = new ArrayList<Long>();
        for (int i = 1; i < parts.length; ++i) {
            long val = YarnOptimizerUtils.toB(Long.parseLong(parts[i]));
            mr.add(val);
        }
        return new ResourceConfig(cp, mr);
    }

    private void addProgramBlocks(ArrayList<ProgramBlock> pbs, long init) {
        for (ProgramBlock pb : pbs) {
            this.addProgramBlock(pb, init);
        }
    }

    private void addProgramBlock(ProgramBlock pb, long init) {
        if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            this.addProgramBlocks(fpb.getChildBlocks(), init);
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock fpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)pb.getStatementBlock();
            if (wsb != null && wsb.getPredicateHops() != null) {
                this._mrres.add(init);
            }
            this.addProgramBlocks(fpb.getChildBlocks(), init);
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock fpb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)pb.getStatementBlock();
            if (isb != null && isb.getPredicateHops() != null) {
                this._mrres.add(init);
            }
            this.addProgramBlocks(fpb.getChildBlocksIfBody(), init);
            this.addProgramBlocks(fpb.getChildBlocksElseBody(), init);
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)pb.getStatementBlock();
            if (fsb != null) {
                this._mrres.add(init);
            }
            this.addProgramBlocks(fpb.getChildBlocks(), init);
        } else {
            this._mrres.add(init);
        }
    }
}

