/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ServletUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HftpFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable,
TokenAspect.TokenManagementDelegator {
    public static final String SCHEME = "hftp";
    URLConnectionFactory connectionFactory;
    public static final Text TOKEN_KIND;
    protected UserGroupInformation ugi;
    private URI hftpURI;
    protected URI nnUri;
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    protected TokenAspect<? extends HftpFileSystem> tokenAspect;
    private Token<?> delegationToken;
    private Token<?> renewToken;
    protected Text tokenServiceName;
    protected static final ThreadLocal<SimpleDateFormat> df;

    @Override
    public URI getCanonicalUri() {
        return super.getCanonicalUri();
    }

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    protected InetSocketAddress getNamenodeAddr(URI uri) {
        return NetUtils.createSocketAddr((String)uri.getAuthority(), (int)this.getDefaultPort());
    }

    protected URI getNamenodeUri(URI uri) {
        return DFSUtil.createUri((String)this.getUnderlyingProtocol(), (InetSocketAddress)this.getNamenodeAddr(uri));
    }

    @Override
    public String getCanonicalServiceName() {
        return SecurityUtil.buildTokenService(this.nnUri).toString();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
    }

    @Override
    public String getScheme() {
        return "hftp";
    }

    protected void initTokenAspect() {
        this.tokenAspect = new TokenAspect((FileSystem)this, this.tokenServiceName, TOKEN_KIND);
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnUri = this.getNamenodeUri(name);
        this.tokenServiceName = SecurityUtil.buildTokenService(this.nnUri);
        try {
            this.hftpURI = new URI(name.getScheme(), name.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.initTokenAspect();
        if (UserGroupInformation.isSecurityEnabled()) {
            this.tokenAspect.initDelegationToken(this.ugi);
        }
    }

    @Override
    public Token<?> getRenewToken() {
        return this.renewToken;
    }

    protected String getUnderlyingProtocol() {
        return "http";
    }

    @Override
    public synchronized <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.renewToken = token;
        this.delegationToken = new Token<T>(token);
        this.delegationToken.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    @Override
    public synchronized Token<?> getDelegationToken(String renewer) throws IOException {
        try {
            String proxyUser;
            UserGroupInformation connectUgi = this.ugi.getRealUser();
            String string = proxyUser = connectUgi == null ? null : this.ugi.getShortUserName();
            if (connectUgi == null) {
                connectUgi = this.ugi;
            }
            return (Token)connectUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getUri() {
        return this.hftpURI;
    }

    protected URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL(this.getUnderlyingProtocol(), this.nnUri.getHost(), this.nnUri.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace("url=" + url);
        }
        return url;
    }

    private String getEncodedUgiParameter() {
        StringBuilder ugiParameter = new StringBuilder(ServletUtil.encodeQueryValue((String)this.ugi.getShortUserName()));
        for (String g : this.ugi.getGroupNames()) {
            ugiParameter.append(",");
            ugiParameter.append(ServletUtil.encodeQueryValue((String)g));
        }
        return ugiParameter.toString();
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        query = this.addDelegationTokenParam(query);
        URL url = this.getNamenodeURL(path, query);
        HttpURLConnection connection = (HttpURLConnection)this.connectionFactory.openConnection(url);
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDelegationTokenParam(String query) throws IOException {
        String tokenString = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            HftpFileSystem hftpFileSystem = this;
            synchronized (hftpFileSystem) {
                this.tokenAspect.ensureTokenInitialized();
                if (this.delegationToken != null) {
                    tokenString = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam((String)tokenString);
                }
            }
        }
        return query;
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        f = f.makeQualified(this.getUri(), this.getWorkingDirectory());
        String path = "/data" + ServletUtil.encodePath((String)f.toUri().getPath());
        String query = this.addDelegationTokenParam("ugi=" + this.getEncodedUgiParameter());
        URL u = this.getNamenodeURL(path, query);
        return new FSDataInputStream(new RangeHeaderInputStream(this.connectionFactory, u));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.tokenAspect.removeRenewAction();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser(this);
        return lsparser.listStatus(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser(this);
        return lsparser.getFileStatus(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return ChecksumParser.access$200((ChecksumParser)new ChecksumParser(this, null), (String)s);
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this.getUri(), null);
    }

    @Override
    public void setWorkingDirectory(Path f) {
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = ContentSummaryParser.access$500((ContentSummaryParser)new ContentSummaryParser(this, null), (String)s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    @Override
    public long renewDelegationToken(Token<?> token) throws IOException {
        UserGroupInformation connectUgi = this.ugi.getRealUser();
        if (connectUgi == null) {
            connectUgi = this.ugi;
        }
        try {
            return (Long)connectUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void cancelDelegationToken(Token<?> token) throws IOException {
        UserGroupInformation connectUgi = this.ugi.getRealUser();
        if (connectUgi == null) {
            connectUgi = this.ugi;
        }
        try {
            connectUgi.doAs(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    static /* synthetic */ String access$000(HftpFileSystem x0) {
        return x0.getEncodedUgiParameter();
    }

    static /* synthetic */ ContentSummary access$300(Attributes x0) throws SAXException {
        return HftpFileSystem.toContentSummary(x0);
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        TOKEN_KIND = new Text("HFTP delegation");
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
    }

    static class RangeHeaderInputStream
    extends ByteRangeInputStream {
        RangeHeaderInputStream(RangeHeaderUrlOpener o, RangeHeaderUrlOpener r) throws IOException {
            super((ByteRangeInputStream.URLOpener)o, (ByteRangeInputStream.URLOpener)r);
        }

        RangeHeaderInputStream(URLConnectionFactory connFactory, URL url) throws IOException {
            this(new RangeHeaderUrlOpener(connFactory, url), new RangeHeaderUrlOpener(connFactory, null));
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) {
            return connection.getURL();
        }
    }
}

