/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import org.apache.sysml.parser.DMLProgram;

public class DMLProgramCounter {
    private String namespace;
    private String fname;
    private int programBlockNumber;
    private int instNumber;
    private long instID = 0L;
    private int lineNumber = 0;

    public DMLProgramCounter() {
    }

    public DMLProgramCounter(String name, String fn, int blockNum, int instNum) {
        this();
        this.namespace = name;
        this.fname = fn;
        this.programBlockNumber = blockNum;
        this.instNumber = instNum;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFunctionName() {
        return this.fname;
    }

    public int getProgramBlockNumber() {
        return this.programBlockNumber;
    }

    public int getInstNumber() {
        return this.instNumber;
    }

    public long getInstID() {
        return this.instID;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setNamespace(String name) {
        this.namespace = name;
    }

    public void setFunctionName(String fn) {
        this.fname = fn;
    }

    public void setProgramBlockNumber(int blockNum) {
        this.programBlockNumber = blockNum;
    }

    public void setInstNumber(int instNum) {
        this.instNumber = instNum;
    }

    public void setInstID(long instID) {
        this.instID = instID;
    }

    public void setLineNumber(int lineNum) {
        this.lineNumber = lineNum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DMLProgram.constructFunctionKey(this.namespace, this.fname));
        sb.append(" instID ");
        sb.append(this.instID);
        sb.append(": (line ");
        sb.append(this.lineNumber);
        sb.append(")");
        return sb.toString();
    }

    public String toStringWithoutInstructionID() {
        StringBuilder sb = new StringBuilder();
        sb.append(DMLProgram.constructFunctionKey(this.namespace, this.fname));
        sb.append(": (line ");
        sb.append(this.lineNumber);
        sb.append(")");
        return sb.toString();
    }
}

