/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.stat;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Stat;

public class StatisticMonitor {
    private static HashMap<Long, Long> _mapPwPf = new HashMap();
    private static HashMap<Long, HashMap<Stat, LinkedList<Double>>> _pfstats = new HashMap();
    private static HashMap<Long, HashMap<Stat, LinkedList<Double>>> _pwstats = new HashMap();
    private static boolean _disabled;

    public static void putPfPwMapping(long pfid, long pwid) {
        if (_disabled) {
            return;
        }
        _mapPwPf.put(pwid, pfid);
    }

    public static void putPFStat(long id, Stat type, double s) {
        HashMap<Stat, LinkedList<Double>> allstats;
        if (_disabled) {
            return;
        }
        if (!_pfstats.containsKey(id)) {
            _pfstats.put(id, new HashMap());
        }
        if (!(allstats = _pfstats.get(id)).containsKey((Object)type)) {
            allstats.put(type, new LinkedList());
        }
        LinkedList<Double> stats = allstats.get((Object)type);
        stats.addLast(s);
    }

    public static void putPWStat(long id, Stat type, double s) {
        HashMap<Stat, LinkedList<Double>> allstats;
        if (_disabled) {
            return;
        }
        if (!_pwstats.containsKey(id)) {
            _pwstats.put(id, new HashMap());
        }
        if (!(allstats = _pwstats.get(id)).containsKey((Object)type)) {
            allstats.put(type, new LinkedList());
        }
        LinkedList<Double> stats = allstats.get((Object)type);
        stats.addLast(s);
    }

    public static void disableStatMonitoring() {
        _disabled = true;
    }

    public static String createReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("############################################## \n");
        sb.append("## ParFOR Runtime Statistics Report         ## \n");
        sb.append("############################################## \n");
        for (Long pfid : _pfstats.keySet()) {
            sb.append("\n");
            sb.append("##############################################\n");
            sb.append("## ParFOR (ID=" + pfid + ") Execution Statistics:\n");
            HashMap<Stat, LinkedList<Double>> stats = _pfstats.get(pfid);
            for (int i = 0; i < stats.get((Object)Stat.PARFOR_NUMTHREADS).size(); ++i) {
                sb.append(" Run #" + i + "\n");
                sb.append("  Num Threads      = " + (int)stats.get((Object)Stat.PARFOR_NUMTHREADS).get(i).doubleValue() + "\n");
                sb.append("  TaskSize         = " + (int)stats.get((Object)Stat.PARFOR_TASKSIZE).get(i).doubleValue() + "\n");
                sb.append("  Task Partitioner = " + (Object)((Object)ParForProgramBlock.PTaskPartitioner.values()[(int)stats.get((Object)Stat.PARFOR_TASKPARTITIONER).get(i).doubleValue()]) + "\n");
                sb.append("  Data Partitioner = " + (Object)((Object)ParForProgramBlock.PDataPartitioner.values()[(int)stats.get((Object)Stat.PARFOR_DATAPARTITIONER).get(i).doubleValue()]) + "\n");
                sb.append("  Exec Mode        = " + (Object)((Object)ParForProgramBlock.PExecMode.values()[(int)stats.get((Object)Stat.PARFOR_EXECMODE).get(i).doubleValue()]) + "\n");
                sb.append("  Num Tasks        = " + (int)stats.get((Object)Stat.PARFOR_NUMTASKS).get(i).doubleValue() + "\n");
                sb.append("  Num Iterations   = " + (int)stats.get((Object)Stat.PARFOR_NUMITERS).get(i).doubleValue() + "\n");
                if (stats.containsKey((Object)Stat.OPT_OPTIMIZER)) {
                    sb.append("  Optimizer               = " + (Object)((Object)ParForProgramBlock.POptMode.values()[(int)stats.get((Object)Stat.OPT_OPTIMIZER).get(i).doubleValue()]) + "\n");
                    sb.append("  Opt Num Total Plans     = " + (int)stats.get((Object)Stat.OPT_NUMTPLANS).get(i).doubleValue() + "\n");
                    sb.append("  Opt Num Evaluated Plans = " + (int)stats.get((Object)Stat.OPT_NUMEPLANS).get(i).doubleValue() + "\n");
                    sb.append("  Time INIT OPTIM   = " + stats.get((Object)Stat.OPT_T).get(i) + "ms\n");
                }
                sb.append("  Time INIT DATA    = " + stats.get((Object)Stat.PARFOR_INIT_DATA_T).get(i) + "ms\n");
                sb.append("  Time INIT PARWRK  = " + stats.get((Object)Stat.PARFOR_INIT_PARWRK_T).get(i) + "ms\n");
                sb.append("  Time INIT TASKS   = " + stats.get((Object)Stat.PARFOR_INIT_TASKS_T).get(i) + "ms\n");
                sb.append("  Time WAIT EXEC    = " + stats.get((Object)Stat.PARFOR_WAIT_EXEC_T).get(i) + "ms\n");
                sb.append("  Time WAIT RESULT  = " + stats.get((Object)Stat.PARFOR_WAIT_RESULTS_T).get(i) + "ms\n");
                int count2 = 1;
                for (Map.Entry<Long, Long> e : _mapPwPf.entrySet()) {
                    long pid;
                    HashMap<Stat, LinkedList<Double>> stats2;
                    if (!e.getValue().equals(pfid) || (stats2 = _pwstats.get(pid = e.getKey().longValue())) == null) continue;
                    int ntasks = (int)stats2.get((Object)Stat.PARWRK_NUMTASKS).get(0).doubleValue();
                    int niters = (int)stats2.get((Object)Stat.PARWRK_NUMITERS).get(0).doubleValue();
                    sb.append("   ------------------------\n");
                    sb.append("   --- ParWorker #" + count2 + " (ID=" + pid + ") Execution Statistics:\n");
                    sb.append("       Num Tasks = " + ntasks + "\n");
                    sb.append("       Num Iters = " + niters + "\n");
                    sb.append("       Time EXEC = " + stats2.get((Object)Stat.PARWRK_EXEC_T).get(0) + "ms\n");
                    LinkedList<Double> taskexec = stats2.get((Object)Stat.PARWRK_TASK_T);
                    LinkedList<Double> tasksize = stats2.get((Object)Stat.PARWRK_TASKSIZE);
                    LinkedList<Double> iterexec = stats2.get((Object)Stat.PARWRK_ITER_T);
                    int count3 = 0;
                    for (int k1 = 0; k1 < ntasks; ++k1) {
                        int ltasksize = (int)tasksize.get(k1).doubleValue();
                        sb.append("        Task #" + (k1 + 1) + ": \n");
                        sb.append("         Task Size = " + ltasksize + "\n");
                        sb.append("         Time EXEC = " + taskexec.get(k1) + "ms\n");
                        for (int k2 = 0; k2 < ltasksize; ++k2) {
                            sb.append("          Iteration #" + (k2 + 1) + ": Time EXEC = " + iterexec.get(count3) + "ms\n");
                            ++count3;
                        }
                    }
                    ++count2;
                }
            }
        }
        sb.append("############################################## \n");
        sb.append("############################################## \n");
        return sb.toString();
    }
}

