/*
 * Decompiled with CFR 0.152.
 */
package jcuda;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class BufferUtils {
    public static ByteBuffer createByteBuffer(int elements) {
        return ByteBuffer.allocateDirect(elements);
    }

    public static CharBuffer createCharBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asCharBuffer();
    }

    public static ShortBuffer createShortBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asShortBuffer();
    }

    public static IntBuffer createIntBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asIntBuffer();
    }

    public static FloatBuffer createFloatBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asFloatBuffer();
    }

    public static LongBuffer createLongBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asLongBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int elements) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(elements * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asDoubleBuffer();
    }

    private BufferUtils() {
    }
}

