/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupRLE
extends ColGroupOffset {
    private static final long serialVersionUID = 7450232907594748177L;

    protected ColGroupRLE(int numRows) {
        super(numRows);
    }

    protected ColGroupRLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs, int[] cachedCounts) {
        super(colIndices, numRows, zeros, dict, cachedCounts);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.RLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.RLE;
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int blksz = 65535;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int[] astart = new int[numVals];
        int[] apos = this.skipScan(numVals, rl, astart);
        double[] c = target.getDenseBlockValues();
        for (int bi = rl; bi < ru; bi += 65535) {
            int bimax = Math.min(bi + 65535, ru);
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = apos[k];
                int start = astart[k];
                while (bix < blen & start < bimax) {
                    char len = this._data[boff + bix + 1];
                    for (int i = Math.max(rl, start += this._data[boff + bix]) - (rl - offT); i < Math.min(start + len, ru) - (rl - offT); ++i) {
                        int rc = i * target.getNumColumns();
                        for (int j = 0; j < numCols; ++j) {
                            int n = rc + this._colIndexes[j];
                            c[n] = c[n] + values[off + j];
                        }
                    }
                    start += len;
                    bix += 2;
                }
                apos[k] = bix;
                astart[k] = start;
                ++k;
                off += numCols;
            }
        }
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int count = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                count += this._data[boff + bix + 1];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows - sum;
        }
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
            int curRunStartOff = tmp.getValue();
            int curRunEnd = tmp.getValue();
            int count = 0;
            for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                count += Math.min(curRunEnd, ru) - curRunStartOff;
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = ru - rl - sum;
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupRLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, false, this.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        ADictionary rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = ColGroupRLE.genRLEBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupRLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        boolean bl = sparseSafe = sparseSafe || !this._zeros;
        if (sparseSafe) {
            return new ColGroupRLE(this._colIndexes, this._numRows, this._zeros, this.applyBinaryRowOp(op, v, sparseSafe, left), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, false, this.applyBinaryRowOp(op, v, true, left), this._data, this._ptr, this.getCachedCounts());
        }
        ADictionary rvalues = this.applyBinaryRowOp(op, v, sparseSafe, left);
        char[] lbitmap = ColGroupRLE.genRLEBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        this._data = rbitmaps;
        this._ptr = rbitmapOffs;
        this._zeros = false;
        this._dict = this._dict.cloneAndExtend(this._colIndexes.length);
        return new ColGroupRLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs, this.getCachedCounts());
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        int numVals = this.getNumValues();
        if (numVals > 1 && this._numRows > 65535) {
            int blksz = 65535;
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            double[] aval = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
            for (int bi = rl; bi < ru; bi += 65535) {
                int bimax = Math.min(bi + 65535, ru);
                for (int k = 0; k < numVals; ++k) {
                    int bix;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int start = astart[k];
                    for (bix = apos[k]; bix < blen; bix += 2) {
                        char lstart = this._data[boff + bix];
                        char llen = this._data[boff + bix + 1];
                        int from = Math.max(bi, start + lstart);
                        int to = Math.min(start + lstart + llen, bimax);
                        int rix = from;
                        while (rix < to) {
                            int n = rix++;
                            c[n] = c[n] + val;
                        }
                        if (start + lstart + llen >= bimax) break;
                        start += lstart + llen;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this._dict.sumRow(k, square, this._colIndexes.length);
                if (val == 0.0) continue;
                Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
                int curRunStartOff = tmp.getValue();
                int curRunEnd = tmp.getValue();
                for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                    curRunStartOff = curRunEnd + this._data[boff + bix];
                    curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                    int rix = curRunStartOff;
                    while (rix < curRunEnd && rix < ru) {
                        int n = rix++;
                        c[n] = c[n] + val;
                    }
                }
            }
        }
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin, values);
            Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
            int curRunStartOff = tmp.getValue();
            int curRunEnd = tmp.getValue();
            for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int rix = curRunStartOff; rix < curRunEnd && rix < ru; ++rix) {
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    public boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                Arrays.fill(ret, curRunStartOff, curRunEnd, false);
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] astart = new int[numVals];
        int[] apos = this.skipScan(numVals, rl, astart);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = apos[k]; bix < blen && curRunStartOff < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int i = Math.max(curRunStartOff, rl); i < Math.min(curRunEnd, ru); ++i) {
                    int n = i - rl;
                    rnnz[n] = rnnz[n] + numCols;
                }
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int numVals = this.getNumValues();
        int idColOffset = Arrays.binarySearch(this._colIndexes, c);
        if (idColOffset < 0) {
            return 0.0;
        }
        for (int k = 0; k < numVals; ++k) {
            char llen;
            char lstart;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = 0;
            for (int start = 0; bix < blen && start <= r; start += lstart + llen, bix += 2) {
                lstart = this._data[boff + bix];
                llen = this._data[boff + bix + 1];
                int from = start + lstart;
                int to = start + lstart + llen;
                if (r < from || r >= to) continue;
                return this._dict.getValue(k * this._colIndexes.length + idColOffset);
            }
        }
        return 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d ", "Data:", this._data.length));
        sb.append("{");
        sb.append(this._data[0] + "-" + this._data[1]);
        for (int i = 2; i < this._data.length; i += 2) {
            sb.append(", " + this._data[i] + "-" + this._data[i + 1]);
        }
        sb.append("}");
        return sb.toString();
    }

    private int[] skipScan(int numVals, int rl, int[] astart) {
        int[] apos = ColGroupRLE.allocIVector(numVals, rl == 0);
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                    start += lstart + llen;
                }
                apos[k] = bix;
                astart[k] = start;
            }
        }
        return apos;
    }

    private Pair<Integer, Integer> skipScanVal(int k, int rl) {
        int apos = 0;
        int astart = 0;
        if (rl > 0) {
            char llen;
            char lstart;
            int bix;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = 0;
            for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                start += lstart + llen;
            }
            apos = bix;
            astart = start;
        }
        return new Pair<Integer, Integer>(apos, astart);
    }

    @Override
    public void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupRLE && ((ColGroupRLE)that)._data == this._data;
    }

    @Override
    public int getIndexStructureHash() {
        return this._data.hashCode();
    }

    public static char[] genRLEBitmap(int[] offsets, int len) {
        ArrayList<Character> buf = new ArrayList<Character>();
        int lastRunEnd = 0;
        int curRunLen = 0;
        int firstOff = offsets[0];
        while (firstOff > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            firstOff -= 65535;
            lastRunEnd += 65535;
        }
        int curRunOff = firstOff;
        curRunLen = 1;
        for (int i = 1; i < len; ++i) {
            int absOffset = offsets[i];
            int curRunEnd = lastRunEnd + curRunOff + curRunLen;
            if (absOffset > curRunEnd || curRunLen >= 65535) {
                buf.add(Character.valueOf((char)curRunOff));
                buf.add(Character.valueOf((char)curRunLen));
                lastRunEnd = curRunEnd;
                for (curRunOff = absOffset - lastRunEnd; curRunOff > 65535; curRunOff -= 65535) {
                    buf.add(Character.valueOf('\uffff'));
                    buf.add(Character.valueOf('\u0000'));
                    lastRunEnd += 65535;
                }
                curRunLen = 1;
                continue;
            }
            ++curRunLen;
        }
        if (curRunOff + curRunLen > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            curRunOff -= 65535;
        }
        buf.add(Character.valueOf((char)curRunOff));
        buf.add(Character.valueOf((char)curRunLen));
        char[] ret = new char[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = ((Character)buf.get(i)).charValue();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }
}

