/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.utils.MemoryEstimates;

public class Dictionary
extends ADictionary {
    private final double[] _values;

    public Dictionary(double[] values) {
        if (values == null || values.length == 0) {
            throw new DMLCompressionException("Invalid construction of dictionary with null array");
        }
        this._values = values;
    }

    @Override
    public double[] getValues() {
        return this._values;
    }

    @Override
    public double getValue(int i) {
        return i >= this.size() ? 0.0 : this._values[i];
    }

    @Override
    public long getInMemorySize() {
        return Dictionary.getInMemorySize(this.size());
    }

    protected static long getInMemorySize(int valuesCount) {
        return 16L + (long)MemoryEstimates.doubleArrayCost(valuesCount);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        double ret = init;
        for (int i = 0; i < this._values.length; ++i) {
            ret = fn.execute(ret, this._values[i]);
        }
        return ret;
    }

    @Override
    public double[] aggregateTuples(Builtin fn, int nCol) {
        if (nCol == 1) {
            return this._values;
        }
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows];
        for (int i = 0; i < nRows; ++i) {
            int off = i * nCol;
            res[i] = this._values[off];
            for (int j = off + 1; j < off + nCol; ++j) {
                res[i] = fn.execute(res[i], this._values[j]);
            }
        }
        return res;
    }

    @Override
    public Dictionary apply(ScalarOperator op) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            this._values[i] = op.executeScalar(this._values[i]);
        }
        return this;
    }

    @Override
    public Dictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        double[] values = new double[this._values.length + numCols];
        for (int i = 0; i < this._values.length; ++i) {
            values[i] = op.executeScalar(this._values[i]);
        }
        Arrays.fill(values, this._values.length, this._values.length + numCols, newVal);
        return new Dictionary(values);
    }

    @Override
    public Dictionary applyBinaryRowOpRight(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        int i;
        ValueFunction fn = op.fn;
        int len = this.size();
        int lenV = colIndexes.length;
        if (sparseSafe) {
            for (int i2 = 0; i2 < len; ++i2) {
                this._values[i2] = fn.execute(this._values[i2], v[colIndexes[i2 % lenV]]);
            }
            return this;
        }
        double[] values = new double[len + lenV];
        for (i = 0; i < len; ++i) {
            values[i] = fn.execute(this._values[i], v[colIndexes[i % lenV]]);
        }
        while (i < len + lenV) {
            values[i] = fn.execute(0.0, v[colIndexes[i % lenV]]);
            ++i;
        }
        return new Dictionary(values);
    }

    @Override
    public Dictionary applyBinaryRowOpLeft(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes) {
        int i;
        ValueFunction fn = op.fn;
        int len = this.size();
        int lenV = colIndexes.length;
        if (sparseSafe) {
            for (int i2 = 0; i2 < len; ++i2) {
                this._values[i2] = fn.execute(v[colIndexes[i2 % lenV]], this._values[i2]);
            }
            return this;
        }
        double[] values = new double[len + lenV];
        for (i = 0; i < len; ++i) {
            values[i] = fn.execute(v[colIndexes[i % lenV]], this._values[i]);
        }
        while (i < len + lenV) {
            values[i] = fn.execute(v[colIndexes[i % lenV]], 0.0);
            ++i;
        }
        return new Dictionary(values);
    }

    @Override
    public Dictionary clone() {
        return new Dictionary((double[])this._values.clone());
    }

    @Override
    public Dictionary cloneAndExtend(int len) {
        double[] ret = Arrays.copyOf(this._values, this._values.length + len);
        return new Dictionary(ret);
    }

    public static Dictionary read(DataInput in) throws IOException {
        int numVals = in.readInt();
        double[] values = new double[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readDouble();
        }
        return new Dictionary(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.FP64_DICT.ordinal());
        out.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            out.writeDouble(this._values[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5 + 8 * this.size();
    }

    private int size() {
        return this._values.length;
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this._values.length / nCol;
    }

    @Override
    public double[] sumAllRowsToDouble(boolean square, int nrColumns) {
        if (nrColumns == 1 && !square) {
            return this.getValues();
        }
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, square, nrColumns);
        }
        return ret;
    }

    @Override
    public double sumRow(int k, boolean square, int nrColumns) {
        int valOff = k * nrColumns;
        double res = 0.0;
        if (!square) {
            for (int i = 0; i < nrColumns; ++i) {
                res += this._values[valOff + i];
            }
        } else {
            for (int i = 0; i < nrColumns; ++i) {
                res += this._values[valOff + i] * this._values[valOff + i];
            }
        }
        return res;
    }

    @Override
    public double[] colSum(int[] counts, int nCol) {
        double[] res = new double[nCol];
        int idx = 0;
        for (int k = 0; k < this._values.length / nCol; ++k) {
            int cntk = counts[k];
            int j = 0;
            while (j < nCol) {
                int n = j++;
                res[n] = res[n] + this._values[idx++] * (double)cntk;
            }
        }
        return res;
    }

    @Override
    public void colSum(double[] c, int[] counts, int[] colIndexes, boolean square) {
        for (int k = 0; k < this._values.length / colIndexes.length; ++k) {
            int cntk = counts[k];
            for (int j = 0; j < colIndexes.length; ++j) {
                double v = this._values[k * colIndexes.length + j];
                if (square) {
                    int n = colIndexes[j];
                    c[n] = c[n] + v * v * (double)cntk;
                    continue;
                }
                int n = colIndexes[j];
                c[n] = c[n] + v * (double)cntk;
            }
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double out = 0.0;
        int valOff = 0;
        for (int k = 0; k < this._values.length / ncol; ++k) {
            int countK = counts[k];
            for (int j = 0; j < ncol; ++j) {
                out += this.getValue(valOff++) * (double)countK;
            }
        }
        return out;
    }

    @Override
    public double sumsq(int[] counts, int ncol) {
        double out = 0.0;
        int valOff = 0;
        for (int k = 0; k < this._values.length / ncol; ++k) {
            int countK = counts[k];
            for (int j = 0; j < ncol; ++j) {
                double val = this.getValue(valOff++);
                out += val * val * (double)countK;
            }
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dictionary: " + this.hashCode());
        sb.append("\n " + Arrays.toString(this._values));
        return sb.toString();
    }

    @Override
    public void addMaxAndMin(double[] ret, int[] colIndexes) {
        int i;
        double[] mins = new double[colIndexes.length];
        double[] maxs = new double[colIndexes.length];
        for (i = 0; i < colIndexes.length; ++i) {
            mins[i] = this._values[i];
            maxs[i] = this._values[i];
        }
        for (i = colIndexes.length; i < this._values.length; ++i) {
            int idx = i % colIndexes.length;
            mins[idx] = Math.min(this._values[i], mins[idx]);
            maxs[idx] = Math.max(this._values[i], maxs[idx]);
        }
        for (i = 0; i < colIndexes.length; ++i) {
            int idy;
            int n = idy = colIndexes[i] * 2;
            ret[n] = ret[n] + mins[i];
            int n2 = idy + 1;
            ret[n2] = ret[n2] + maxs[i];
        }
    }

    @Override
    public String getString(int colIndexes) {
        StringBuilder sb = new StringBuilder();
        if (colIndexes == 1) {
            sb.append(Arrays.toString(this._values));
        } else {
            sb.append("[\n");
            for (int i = 0; i < this._values.length - 1; ++i) {
                sb.append(this._values[i]);
                sb.append(i % colIndexes == colIndexes - 1 ? "\nt" + i + ": " : ", ");
            }
            sb.append(this._values[this._values.length - 1]);
            sb.append("\n]");
        }
        return sb.toString();
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        int numberTuples = this.getNumberOfValues(previousNumberOfColumns);
        int tupleLengthAfter = idxEnd - idxStart;
        double[] newDictValues = new double[tupleLengthAfter * numberTuples];
        int orgOffset = idxStart;
        int targetOffset = 0;
        for (int v = 0; v < numberTuples; ++v) {
            int c = 0;
            while (c < tupleLengthAfter) {
                newDictValues[targetOffset] = this._values[orgOffset];
                ++c;
                ++orgOffset;
                ++targetOffset;
            }
            orgOffset += previousNumberOfColumns - idxEnd + idxStart;
        }
        return new Dictionary(newDictValues);
    }

    @Override
    public ADictionary reExpandColumns(int max) {
        double[] newDictValues = new double[this._values.length * max];
        int i = 0;
        int offset = 0;
        while (i < this._values.length) {
            int val = (int)Math.floor(this._values[i]) - 1;
            newDictValues[offset + val] = 1.0;
            ++i;
            offset += max;
        }
        return new Dictionary(newDictValues);
    }

    @Override
    public boolean containsValue(double pattern) {
        boolean NaNpattern = Double.isNaN(pattern);
        if (NaNpattern) {
            for (double v : this._values) {
                if (!Double.isNaN(v)) continue;
                return true;
            }
        } else {
            for (double v : this._values) {
                if (v != pattern) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        int nRow = this._values.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            for (int j = off = i * nCol; j < off + nCol; ++j) {
                if (this._values[j] == 0.0) continue;
                ++rowCount;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public void addToEntry(Dictionary d, int fr, int to, int nCol) {
        int sf = nCol * fr;
        int ef = sf + nCol;
        double[] v = d.getValues();
        int j = nCol * to;
        for (int i = sf; i < ef; ++i) {
            int n = j++;
            v[n] = v[n] + this._values[i];
        }
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public double[] getTuple(int index, int nCol) {
        double[] tuple = new double[nCol];
        boolean allZero = true;
        int i = index * nCol;
        int off = 0;
        while (i < (index + 1) * nCol && i < this._values.length) {
            double v = this._values[i];
            if (v != 0.0) {
                tuple[off] = v;
                allZero = false;
            }
            ++i;
            ++off;
        }
        return allZero ? null : tuple;
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        double[] newValues = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            newValues[i] = this._values[i] - tuple[i % tuple.length];
        }
        return new Dictionary(newValues);
    }

    @Override
    public MatrixBlockDictionary getAsMatrixBlockDictionary(int nCol) {
        int nRow = this._values.length / nCol;
        DenseBlockFP64 dictV = new DenseBlockFP64(new int[]{nRow, nCol}, this._values);
        MatrixBlock dictM = new MatrixBlock(nRow, nCol, dictV);
        dictM.getNonZeros();
        dictM.examSparsity();
        return new MatrixBlockDictionary(dictM);
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        int ncol = colIndexes.length;
        int vlen = this.size() / ncol;
        for (int k = 0; k < vlen; ++k) {
            int valOff = k * ncol;
            for (int j = 0; j < ncol; ++j) {
                c[colIndexes[j]] = fn.execute(c[colIndexes[j]], this.getValue(valOff + j));
            }
        }
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        double[] scaledValues = new double[this._values.length];
        int off = 0;
        for (int tuple = 0; tuple < this._values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = this._values[off] * (double)scale;
                ++off;
            }
        }
        return new Dictionary(scaledValues);
    }

    @Override
    public void preaggValuesFromDense(int numVals, int[] colIndexes, int[] aggregateColumns, double[] b, double[] ret, int cut) {
        int k = 0;
        int off = 0;
        while (k < numVals * colIndexes.length) {
            for (int h = 0; h < colIndexes.length; ++h) {
                int idb = colIndexes[h] * cut;
                double v = this._values[k + h];
                if (v == 0.0) continue;
                for (int i = 0; i < aggregateColumns.length; ++i) {
                    int n = off + i;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns[i]];
                }
            }
            k += colIndexes.length;
            off += aggregateColumns.length;
        }
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol, boolean safe) {
        if (!safe && replace == 0.0) {
            throw new NotImplementedException("Not implemented Replacement of 0");
        }
        double[] retV = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            double v = this._values[i];
            retV[i] = v == pattern ? replace : v;
        }
        return new Dictionary(retV);
    }
}

