/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.finegrained;

import java.util.Arrays;

public class DataRange {
    private long[] _beginDims;
    private long[] _endDims;

    public DataRange(long[] beginDims, long[] endDims) {
        this._beginDims = beginDims;
        this._endDims = endDims;
    }

    public long[] getBeginDims() {
        return this._beginDims;
    }

    public long[] getEndDims() {
        return this._endDims;
    }

    public boolean overlaps(DataRange dataRange) {
        long[] dataRangeBegin = dataRange.getBeginDims();
        long[] dataRangeEnd = dataRange.getEndDims();
        if (this._beginDims.length != dataRangeBegin.length || this._endDims.length != dataRangeEnd.length) {
            return false;
        }
        for (int i = 0; i < this._beginDims.length; ++i) {
            if (!this.dimensionOutOfRange(dataRangeBegin, dataRangeEnd, i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(long[] index) {
        if (this._beginDims.length != index.length) {
            return false;
        }
        for (int i = 0; i < this._beginDims.length; ++i) {
            if (this._beginDims[i] <= index[i] && this._endDims[i] >= index[i]) continue;
            return false;
        }
        return true;
    }

    private boolean dimensionOutOfRange(long[] dataRangeBegin, long[] dataRangeEnd, int i) {
        return this._beginDims[i] < dataRangeBegin[i] && this._endDims[i] < dataRangeBegin[i] || this._beginDims[i] > dataRangeBegin[i] && this._beginDims[i] > dataRangeEnd[i];
    }

    public String toString() {
        return Arrays.toString(new String[]{Arrays.toString(this._beginDims), Arrays.toString(this._endDims)});
    }

    public boolean equals(Object other) {
        if (other instanceof DataRange) {
            DataRange otherRange = (DataRange)other;
            return Arrays.equals(this._beginDims, otherRange.getBeginDims()) && Arrays.equals(this._endDims, otherRange.getEndDims());
        }
        return false;
    }
}

