/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

public class MemoryEstimates {
    public static long bitSetCost(int length) {
        long size = 0L;
        size = (long)((double)(size += 8L) + MemoryEstimates.longArrayCost(length / 64 + (length % 64 > 0 ? 1 : 0)));
        size += 4L;
        ++size;
        return size += 3L;
    }

    public static long byteArrayCost(int length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 4) {
            size += 4L;
        } else {
            size += (long)length;
            int diff = (length - 4) % 8;
            if (diff > 0) {
                size += (long)(8 - diff);
            }
        }
        return size;
    }

    public static long charArrayCost(int length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 2) {
            size += 4L;
        } else {
            size += (long)(length * 2);
            int diff = (length * 2 - 4) % 8;
            if (diff > 0) {
                size += (long)(8 - diff);
            }
        }
        return size;
    }

    public static double intArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        if (length <= 1L) {
            size += 4.0;
        } else {
            size += 4.0 * (double)length;
            if (length % 2L == 0L) {
                size += 4.0;
            }
        }
        return size;
    }

    public static double doubleArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        size += 4.0;
        return size += 8.0 * (double)length;
    }

    public static double objectArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        size += 4.0;
        return size += 8.0 * (double)length;
    }

    public static double longArrayCost(int length) {
        return MemoryEstimates.doubleArrayCost(length);
    }
}

