/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceCol;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;

public abstract class ColGroupCompressed
extends AColGroup {
    private static final long serialVersionUID = 3786247536054353658L;
    protected final int _numRows;

    protected ColGroupCompressed(int numRows) {
        this._numRows = numRows;
    }

    protected ColGroupCompressed(int[] colIndices, int numRows) {
        super(colIndices);
        this._numRows = numRows;
    }

    @Override
    public abstract double[] getValues();

    public abstract void addMinMax(double[] var1);

    @Override
    public abstract boolean isLossy();

    protected abstract double computeMxx(double var1, Builtin var3);

    protected abstract void computeColMxx(double[] var1, Builtin var2);

    protected abstract void computeSum(double[] var1, boolean var2);

    protected abstract void computeRowSums(double[] var1, boolean var2, int var3, int var4);

    protected abstract void computeColSums(double[] var1, boolean var2);

    protected abstract void computeRowMxx(double[] var1, Builtin var2, int var3, int var4);

    protected abstract boolean sameIndexStructure(ColGroupCompressed var1);

    @Override
    public final double getMin() {
        return this.computeMxx(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MIN));
    }

    @Override
    public final double getMax() {
        return this.computeMxx(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MAX));
    }

    @Override
    public final void unaryAggregateOperations(AggregateUnaryOperator op, double[] c) {
        this.unaryAggregateOperations(op, c, 0, this._numRows);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void unaryAggregateOperations(AggregateUnaryOperator op, double[] c, int rl, int ru) {
        if (op.aggOp.increOp.fn instanceof Plus || op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq) {
            boolean square = op.aggOp.increOp.fn instanceof KahanPlusSq;
            if (op.indexFn instanceof ReduceAll) {
                this.computeSum(c, square);
                return;
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowSums(c, square, rl, ru);
                return;
            } else {
                if (!(op.indexFn instanceof ReduceRow)) return;
                this.computeColSums(c, square);
            }
            return;
        } else {
            if (!(op.aggOp.increOp.fn instanceof Builtin)) throw new DMLScriptException("Unknown UnaryAggregate operator on CompressedMatrixBlock");
            Builtin bop = (Builtin)op.aggOp.increOp.fn;
            Builtin.BuiltinCode bopC = bop.getBuiltinCode();
            if (bopC != Builtin.BuiltinCode.MAX && bopC != Builtin.BuiltinCode.MIN) throw new DMLScriptException("unsupported builtin type: " + bop);
            if (op.indexFn instanceof ReduceAll) {
                c[0] = this.computeMxx(c[0], bop);
                return;
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowMxx(c, bop, rl, ru);
                return;
            } else {
                if (!(op.indexFn instanceof ReduceRow)) return;
                this.computeColMxx(c, bop);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" num Rows: " + this.getNumRows());
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public final int getNumRows() {
        return this._numRows;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += 4L;
    }
}

