/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.ValueComparisonFunction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryScalarScalarCPInstruction
extends BinaryCPInstruction {
    protected BinaryScalarScalarCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ScalarObject so1 = ec.getScalarInput(this.input1);
        ScalarObject so2 = ec.getScalarInput(this.input2);
        String opcode = this.getOpcode();
        BinaryOperator dop = (BinaryOperator)this._optr;
        ScalarObject sores = null;
        if (dop.fn instanceof ValueComparisonFunction) {
            ValueComparisonFunction vcomp = (ValueComparisonFunction)dop.fn;
            sores = so1 instanceof StringObject || so2 instanceof StringObject ? new BooleanObject(vcomp.compare(so1.getStringValue(), so2.getStringValue())) : (so1 instanceof DoubleObject || so2 instanceof DoubleObject ? new BooleanObject(vcomp.compare(so1.getDoubleValue(), so2.getDoubleValue())) : (so1 instanceof IntObject || so2 instanceof IntObject ? new BooleanObject(vcomp.compare(so1.getLongValue(), so2.getLongValue())) : new BooleanObject(vcomp.compare(so1.getBooleanValue(), so2.getBooleanValue()))));
        } else if (so1 instanceof StringObject || so2 instanceof StringObject) {
            if (!opcode.equals("+")) {
                throw new DMLRuntimeException("Arithmetic '" + opcode + "' not supported over string inputs.");
            }
            sores = new StringObject(dop.fn.execute(so1.getLanguageSpecificStringValue(), so2.getLanguageSpecificStringValue()));
        } else if (so1 instanceof DoubleObject || so2 instanceof DoubleObject || this.output.getValueType() == Types.ValueType.FP64) {
            sores = new DoubleObject(dop.fn.execute(so1.getDoubleValue(), so2.getDoubleValue()));
        } else if (so1 instanceof IntObject || so2 instanceof IntObject) {
            double tmp = dop.fn.execute(so1.getLongValue(), so2.getLongValue());
            if (tmp > 9.223372036854776E18) {
                throw new DMLRuntimeException("Integer operation created numerical result overflow (" + tmp + " > " + Long.MAX_VALUE + ").");
            }
            sores = new IntObject((long)tmp);
        } else {
            sores = opcode.equals("&&") || opcode.equals("||") || opcode.equals("xor") ? new BooleanObject(dop.fn.execute(so1.getBooleanValue(), so2.getBooleanValue())) : new DoubleObject(dop.fn.execute(so1.getDoubleValue(), so2.getDoubleValue()));
        }
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

