/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.ArithmeticBinaryGPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.utils.GPUStatistics;

public class MatrixMatrixAxpyGPUInstruction
extends ArithmeticBinaryGPUInstruction {
    CPOperand constant = null;
    int multiplier = 1;

    private MatrixMatrixAxpyGPUInstruction(Operator op, CPOperand in1, CPOperand constant, int multiplier, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this.constant = constant;
        this.multiplier = multiplier;
    }

    public static MatrixMatrixAxpyGPUInstruction parseInstruction(String str) {
        TernaryOperator operator;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        int multiplier = 1;
        if (opcode.equals("-*")) {
            multiplier = -1;
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand constant = new CPOperand(parts[2]);
        if (constant.getDataType() != Types.DataType.SCALAR) {
            throw new DMLRuntimeException("Expected second operand to be a scalar");
        }
        CPOperand in2 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        Types.DataType dt1 = in1.getDataType();
        Types.DataType dt2 = in2.getDataType();
        Types.DataType dt3 = out.getDataType();
        Operator operator2 = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Types.DataType.SCALAR) : (operator = InstructionUtils.parseTernaryOperator(opcode));
        if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX && dt3 == Types.DataType.MATRIX) {
            return new MatrixMatrixAxpyGPUInstruction(operator, in1, constant, multiplier, in2, out, opcode, str);
        }
        if (dt3 == Types.DataType.MATRIX && (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX || dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR)) {
            throw new DMLRuntimeException("Unsupported GPU PlusMult/MinusMult ArithmeticInstruction.");
        }
        throw new DMLRuntimeException("Unsupported GPU ArithmeticInstruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        MatrixObject in2 = this.getMatrixInputForGPUInstruction(ec, this._input2.getName());
        ScalarObject scalar = ec.getScalarInput(this.constant);
        long rlen1 = in1.getNumRows();
        long clen1 = in1.getNumColumns();
        long rlen2 = in2.getNumRows();
        long clen2 = in2.getNumColumns();
        if (!MatrixMatrixAxpyGPUInstruction.isValidMMOperation(rlen1, rlen2, clen1, clen2) && !MatrixMatrixAxpyGPUInstruction.isValidMVOperation(rlen1, rlen2, clen1, clen2)) {
            throw new DMLRuntimeException("Incorrect dimensions of inputs in GPU axpy operation. input1:" + rlen1 + " X " + clen1 + " and input2:" + rlen2 + " X " + clen2);
        }
        ec.setMetaData(this._output.getName(), (int)rlen1, (int)clen1);
        LibMatrixCUDA.axpy(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, in2, this._output.getName(), (double)this.multiplier * scalar.getDoubleValue());
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    private static boolean isValidMMOperation(long rlen1, long rlen2, long clen1, long clen2) {
        return rlen1 == rlen2 && clen1 == clen2;
    }

    private static boolean isValidMVOperation(long rlen1, long rlen2, long clen1, long clen2) {
        return rlen1 == rlen2 && clen2 == 1L || rlen2 == 1L && clen1 == clen2;
    }
}

