/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class EditLogOutputStream
implements Closeable {
    private long numSync = 0L;
    private long totalTimeSync = 0L;

    public abstract void write(FSEditLogOp var1) throws IOException;

    public abstract void writeRaw(byte[] var1, int var2, int var3) throws IOException;

    public abstract void create(int var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void abort() throws IOException;

    public abstract void setReadyToFlush() throws IOException;

    protected abstract void flushAndSync(boolean var1) throws IOException;

    public void flush() throws IOException {
        this.flush(true);
    }

    public void flush(boolean durable) throws IOException {
        ++this.numSync;
        long start = Time.now();
        this.flushAndSync(durable);
        long end = Time.now();
        this.totalTimeSync += end - start;
    }

    public boolean shouldForceSync() {
        return false;
    }

    long getTotalSyncTime() {
        return this.totalTimeSync;
    }

    protected long getNumSync() {
        return this.numSync;
    }

    public String generateReport() {
        return this.toString();
    }
}

