/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DoubleObject
extends ScalarObject {
    private static final long serialVersionUID = -8525290101679236360L;
    private final double _value;

    public DoubleObject(double val) {
        super(Types.ValueType.FP64);
        this._value = val;
    }

    @Override
    public boolean getBooleanValue() {
        return this._value != 0.0;
    }

    @Override
    public long getLongValue() {
        return UtilFunctions.toLong(this._value);
    }

    @Override
    public double getDoubleValue() {
        return this._value;
    }

    @Override
    public String getStringValue() {
        return Double.toString(this._value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public String getDebugName() {
        return null;
    }

    @Override
    public int getSize() {
        return 24;
    }
}

