/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.io;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.spark_project.jetty.io.ByteBufferPool;
import org.spark_project.jetty.util.BufferUtil;

public class MappedByteBufferPool
implements ByteBufferPool {
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> directBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final ConcurrentMap<Integer, Queue<ByteBuffer>> heapBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final int factor;

    public MappedByteBufferPool() {
        this(1024);
    }

    public MappedByteBufferPool(int factor) {
        this.factor = factor;
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        int bucket = this.bucketFor(size);
        ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(direct);
        ByteBuffer result2 = null;
        Queue byteBuffers = (Queue)buffers.get(bucket);
        if (byteBuffers != null) {
            result2 = (ByteBuffer)byteBuffers.poll();
        }
        if (result2 == null) {
            int capacity = bucket * this.factor;
            result2 = this.newByteBuffer(capacity, direct);
        }
        BufferUtil.clear(result2);
        return result2;
    }

    protected ByteBuffer newByteBuffer(int capacity, boolean direct) {
        return direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        assert (buffer.capacity() % this.factor == 0);
        int bucket = this.bucketFor(buffer.capacity());
        ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(buffer.isDirect());
        Queue<ByteBuffer> byteBuffers = (ConcurrentLinkedQueue<ByteBuffer>)buffers.get(bucket);
        if (byteBuffers == null) {
            byteBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
            Queue existing = buffers.putIfAbsent(bucket, byteBuffers);
            if (existing != null) {
                byteBuffers = existing;
            }
        }
        BufferUtil.clear(buffer);
        byteBuffers.offer(buffer);
    }

    public void clear() {
        this.directBuffers.clear();
        this.heapBuffers.clear();
    }

    private int bucketFor(int size) {
        int bucket = size / this.factor;
        if (size % this.factor > 0) {
            ++bucket;
        }
        return bucket;
    }

    ConcurrentMap<Integer, Queue<ByteBuffer>> buffersFor(boolean direct) {
        return direct ? this.directBuffers : this.heapBuffers;
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        @Override
        protected ByteBuffer newByteBuffer(int capacity, boolean direct) {
            ByteBuffer buffer = super.newByteBuffer(capacity + 4, direct);
            buffer.limit(buffer.capacity());
            buffer.putInt(this.tag.incrementAndGet());
            ByteBuffer slice2 = buffer.slice();
            BufferUtil.clear(slice2);
            return slice2;
        }
    }
}

