/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.PureJavaCrc32;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class SpillRecord {
    private final ByteBuffer buf;
    private final LongBuffer entries;

    public SpillRecord(int numPartitions) {
        this.buf = ByteBuffer.allocate(numPartitions * 24);
        this.entries = this.buf.asLongBuffer();
    }

    public SpillRecord(Path indexFileName, JobConf job) throws IOException {
        this(indexFileName, job, null);
    }

    public SpillRecord(Path indexFileName, JobConf job, String expectedIndexOwner) throws IOException {
        this(indexFileName, job, (Checksum)new PureJavaCrc32(), expectedIndexOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpillRecord(Path indexFileName, JobConf job, Checksum crc, String expectedIndexOwner) throws IOException {
        FileSystem rfs = FileSystem.getLocal((Configuration)job).getRaw();
        FSDataInputStream in = SecureIOUtils.openFSDataInputStream((File)new File(indexFileName.toUri().getRawPath()), (String)expectedIndexOwner, null);
        try {
            long length = rfs.getFileStatus(indexFileName).getLen();
            int partitions = (int)length / 24;
            int size = partitions * 24;
            this.buf = ByteBuffer.allocate(size);
            if (crc != null) {
                crc.reset();
                CheckedInputStream chk = new CheckedInputStream((InputStream)in, crc);
                IOUtils.readFully((InputStream)chk, (byte[])this.buf.array(), (int)0, (int)size);
                if (chk.getChecksum().getValue() != in.readLong()) {
                    throw new ChecksumException("Checksum error reading spill index: " + indexFileName, -1L);
                }
            } else {
                IOUtils.readFully((InputStream)in, (byte[])this.buf.array(), (int)0, (int)size);
            }
            this.entries = this.buf.asLongBuffer();
        }
        finally {
            in.close();
        }
    }

    public int size() {
        return this.entries.capacity() / 3;
    }

    public IndexRecord getIndex(int partition) {
        int pos = partition * 24 / 8;
        return new IndexRecord(this.entries.get(pos), this.entries.get(pos + 1), this.entries.get(pos + 2));
    }

    public void putIndex(IndexRecord rec, int partition) {
        int pos = partition * 24 / 8;
        this.entries.put(pos, rec.startOffset);
        this.entries.put(pos + 1, rec.rawLength);
        this.entries.put(pos + 2, rec.partLength);
    }

    public void writeToFile(Path loc, JobConf job) throws IOException {
        this.writeToFile(loc, job, (Checksum)new PureJavaCrc32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(Path loc, JobConf job, Checksum crc) throws IOException {
        FileSystem rfs = FileSystem.getLocal((Configuration)job).getRaw();
        FilterOutputStream chk = null;
        FSDataOutputStream out = rfs.create(loc);
        try {
            if (crc != null) {
                crc.reset();
                chk = new CheckedOutputStream((OutputStream)out, crc);
                chk.write(this.buf.array());
                out.writeLong(((CheckedOutputStream)chk).getChecksum().getValue());
            } else {
                out.write(this.buf.array());
            }
        }
        finally {
            if (chk != null) {
                chk.close();
            } else {
                out.close();
            }
        }
    }
}

