/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.db.BigDecimalSplitter;
import org.apache.hadoop.mapreduce.lib.db.BooleanSplitter;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBSplitter;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.DateSplitter;
import org.apache.hadoop.mapreduce.lib.db.FloatSplitter;
import org.apache.hadoop.mapreduce.lib.db.IntegerSplitter;
import org.apache.hadoop.mapreduce.lib.db.MySQLDataDrivenDBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.TextSplitter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DataDrivenDBInputFormat<T extends DBWritable>
extends DBInputFormat<T>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(DataDrivenDBInputFormat.class);
    public static final String SUBSTITUTE_TOKEN = "$CONDITIONS";

    protected DBSplitter getSplitter(int sqlDataType) {
        switch (sqlDataType) {
            case 2: 
            case 3: {
                return new BigDecimalSplitter();
            }
            case -7: 
            case 16: {
                return new BooleanSplitter();
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return new IntegerSplitter();
            }
            case 6: 
            case 7: 
            case 8: {
                return new FloatSplitter();
            }
            case -1: 
            case 1: 
            case 12: {
                return new TextSplitter();
            }
            case 91: 
            case 92: 
            case 93: {
                return new DateSplitter();
            }
        }
        return null;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        int targetNumTasks = job.getConfiguration().getInt("mapreduce.job.maps", 1);
        if (1 == targetNumTasks) {
            ArrayList<InputSplit> singletonSplit = new ArrayList<InputSplit>();
            singletonSplit.add(new DataDrivenDBInputSplit("1=1", "1=1"));
            return singletonSplit;
        }
        ResultSet results = null;
        Statement statement = null;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement();
            results = statement.executeQuery(this.getBoundingValsQuery());
            results.next();
            int sqlDataType = results.getMetaData().getColumnType(1);
            DBSplitter splitter = this.getSplitter(sqlDataType);
            if (null == splitter) {
                throw new IOException("Unknown SQL data type: " + sqlDataType);
            }
            List<InputSplit> list = splitter.split(job.getConfiguration(), results, this.getDBConf().getInputOrderBy());
            return list;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (null != results) {
                    results.close();
                }
            }
            catch (SQLException se) {
                LOG.debug((Object)("SQLException closing resultset: " + se.toString()));
            }
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                LOG.debug((Object)("SQLException closing statement: " + se.toString()));
            }
            try {
                connection.commit();
                this.closeConnection();
            }
            catch (SQLException se) {
                LOG.debug((Object)("SQLException committing split transaction: " + se.toString()));
            }
        }
    }

    protected String getBoundingValsQuery() {
        String userQuery = this.getDBConf().getInputBoundingQuery();
        if (null != userQuery) {
            return userQuery;
        }
        StringBuilder query = new StringBuilder();
        String splitCol = this.getDBConf().getInputOrderBy();
        query.append("SELECT MIN(").append(splitCol).append("), ");
        query.append("MAX(").append(splitCol).append(") FROM ");
        query.append(this.getDBConf().getInputTableName());
        String conditions = this.getDBConf().getInputConditions();
        if (null != conditions) {
            query.append(" WHERE ( " + conditions + " )");
        }
        return query.toString();
    }

    public static void setBoundingQuery(Configuration conf, String query) {
        if (null != query && query.indexOf(SUBSTITUTE_TOKEN) == -1) {
            LOG.warn((Object)("Could not find $CONDITIONS token in query: " + query + "; splits may not partition data."));
        }
        conf.set("mapred.jdbc.input.bounding.query", query);
    }

    @Override
    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        DBConfiguration dbConf = this.getDBConf();
        Class<?> inputClass = dbConf.getInputClass();
        String dbProductName = this.getDBProductName();
        LOG.debug((Object)("Creating db record reader for db product: " + dbProductName));
        try {
            if (dbProductName.startsWith("MYSQL")) {
                return new MySQLDataDrivenDBRecordReader(split, inputClass, conf, this.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName());
            }
            return new DataDrivenDBRecordReader(split, inputClass, conf, this.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName(), dbProductName);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String splitBy, String ... fieldNames) {
        DBInputFormat.setInput(job, inputClass, tableName, conditions, splitBy, fieldNames);
        job.setInputFormatClass(DataDrivenDBInputFormat.class);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String inputQuery, String inputBoundingQuery) {
        DBInputFormat.setInput(job, inputClass, inputQuery, "");
        job.getConfiguration().set("mapred.jdbc.input.bounding.query", inputBoundingQuery);
        job.setInputFormatClass(DataDrivenDBInputFormat.class);
    }

    @InterfaceStability.Evolving
    public static class DataDrivenDBInputSplit
    extends DBInputFormat.DBInputSplit {
        private String lowerBoundClause;
        private String upperBoundClause;

        public DataDrivenDBInputSplit() {
        }

        public DataDrivenDBInputSplit(String lower, String upper) {
            this.lowerBoundClause = lower;
            this.upperBoundClause = upper;
        }

        @Override
        public long getLength() throws IOException {
            return 0L;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            this.lowerBoundClause = Text.readString((DataInput)input);
            this.upperBoundClause = Text.readString((DataInput)input);
        }

        @Override
        public void write(DataOutput output) throws IOException {
            Text.writeString((DataOutput)output, (String)this.lowerBoundClause);
            Text.writeString((DataOutput)output, (String)this.upperBoundClause);
        }

        public String getLowerClause() {
            return this.lowerBoundClause;
        }

        public String getUpperClause() {
            return this.upperBoundClause;
        }
    }
}

