# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/img_crop.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def img_crop(img_in: Matrix,
             w: int,
             h: int,
             x_offset: int,
             y_offset: int):
    """
     The img_crop-function is an image data augmentation function. It cuts out a subregion of an image.
    
    
    
    :param img_in: Input matrix/image
    :param w: The width of the subregion required
    :param h: The height of the subregion required
    :param x_offset: The horizontal coordinate in the image to begin the crop operation
    :param y_offset: The vertical coordinate in the image to begin the crop operation
    :return: Cropped matrix/image
    """

    params_dict = {'img_in': img_in, 'w': w, 'h': h, 'x_offset': x_offset, 'y_offset': y_offset}
    return Matrix(img_in.sds_context,
        'img_crop',
        named_input_nodes=params_dict)
