/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Ternary
extends Lop {
    private final Types.OpOp3 _op;
    private final int _numThreads;

    public Ternary(Types.OpOp3 op, Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        super(Lop.Type.Ternary, dt, vt);
        this._op = op;
        this._numThreads = numThreads;
        this.init(input1, input2, input3, et);
    }

    private void init(Lop input1, Lop input2, Lop input3, Types.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = t(" + this._op.toString() + ")";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), this._op.toString(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(2).prepInputOperand(input3), this.prepOutputOperand(output));
        if (this.getDataType().isMatrix()) {
            if (this.getExecType() == Types.ExecType.CP) {
                ret = InstructionUtils.concatOperands(ret, String.valueOf(this._numThreads));
            } else if (this.getExecType() == Types.ExecType.FED) {
                ret = InstructionUtils.concatOperands(ret, String.valueOf(this._numThreads), this._fedOutput.name());
            }
        }
        return ret;
    }
}

