/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.CombinedIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoRangesIndex;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;

public abstract class AColIndex
implements IColIndex {
    protected static final Log LOG = LogFactory.getLog((String)AColIndex.class.getName());

    @Override
    public int hashCode() {
        return AColIndex.hashCode(this.iterator());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof IColIndex && this.equals((IColIndex)other);
    }

    @Override
    public boolean contains(IColIndex a, IColIndex b) {
        return a != null && b != null && this.findIndex(a.get(0)) >= 0 && this.findIndex(b.get(0)) >= 0;
    }

    @Override
    public boolean containsStrict(IColIndex a, IColIndex b) {
        if (a != null && b != null && a.size() + b.size() == this.size()) {
            IIterate ia = a.iterator();
            while (ia.hasNext()) {
                if (this.findIndex(ia.next()) >= 0) continue;
                return false;
            }
            IIterate ib = b.iterator();
            while (ib.hasNext()) {
                if (this.findIndex(ib.next()) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int hashCode(IIterate it) {
        int res = 1;
        while (it.hasNext()) {
            res = 31 * res + it.next();
        }
        return res;
    }

    @Override
    public boolean containsAny(IColIndex idx) {
        if (idx instanceof TwoRangesIndex) {
            TwoRangesIndex o = (TwoRangesIndex)idx;
            return this.containsAny(o.idx1) || this.containsAny(o.idx2);
        }
        if (idx instanceof CombinedIndex) {
            CombinedIndex ci = (CombinedIndex)idx;
            return this.containsAny(ci.l) || this.containsAny(ci.r);
        }
        IIterate it = idx.iterator();
        while (it.hasNext()) {
            if (!this.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void decompressToDenseFromSparse(SparseBlock sb, int vr, int off, double[] c) {
        if (sb instanceof SparseBlockCSR) {
            this.decompressToDenseFromSparseCSR((SparseBlockCSR)sb, vr, off, c);
        } else {
            this.decompressToDenseFromSparseGeneric(sb, vr, off, c);
        }
    }

    private void decompressToDenseFromSparseGeneric(SparseBlock sb, int vr, int off, double[] c) {
        if (sb.isEmpty(vr)) {
            return;
        }
        int apos = sb.pos(vr);
        int alen = sb.size(vr) + apos;
        int[] aix = sb.indexes(vr);
        double[] aval = sb.values(vr);
        for (int j = apos; j < alen; ++j) {
            int n = off + this.get(aix[j]);
            c[n] = c[n] + aval[j];
        }
    }

    private void decompressToDenseFromSparseCSR(SparseBlockCSR sb, int vr, int off, double[] c) {
        int apos = sb.pos(vr);
        int alen = sb.size(vr) + apos;
        int[] aix = sb.indexes(vr);
        double[] aval = sb.values(vr);
        for (int j = apos; j < alen; ++j) {
            int n = off + this.get(aix[j]);
            c[n] = c[n] + aval[j];
        }
    }

    @Override
    public void decompressVec(int nCol, double[] c, int off, double[] values, int rowIdx) {
        for (int j = 0; j < nCol; ++j) {
            int n = off + this.get(j);
            c[n] = c[n] + values[rowIdx + j];
        }
    }
}

