/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.lib.CLALibBinaryCellOp;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.functionobjects.TernaryValueFunction;
import org.apache.sysds.runtime.matrix.data.LibMatrixTercell;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;

public final class CLALibTernaryOp {
    private CLALibTernaryOp() {
    }

    public static MatrixBlock ternaryOperations(CompressedMatrixBlock m1, TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        boolean PM_Or_MM;
        int r1 = m1.getNumRows();
        int r2 = m2.getNumRows();
        int r3 = m3.getNumRows();
        int c1 = m1.getNumColumns();
        int c2 = m2.getNumColumns();
        int c3 = m3.getNumColumns();
        boolean s1 = r1 == 1 && c1 == 1;
        boolean s2 = r2 == 1 && c2 == 1;
        boolean s3 = r3 == 1 && c3 == 1;
        double d1 = s1 ? m1.quickGetValue(0, 0) : Double.NaN;
        double d2 = s2 ? m2.quickGetValue(0, 0) : Double.NaN;
        double d3 = s3 ? m3.quickGetValue(0, 0) : Double.NaN;
        int m = Math.max(Math.max(r1, r2), r3);
        int n = Math.max(Math.max(c1, c2), c3);
        MatrixBlock.ternaryOperationCheck(s1, s2, s3, m, r1, r2, r3, n, c1, c2, c3);
        boolean bl = PM_Or_MM = op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply;
        if (PM_Or_MM && (s2 && d2 == 0.0 || s3 && d3 == 0.0)) {
            ret = new CompressedMatrixBlock();
            ret.copy(m1);
            return ret;
        }
        if (m2 instanceof CompressedMatrixBlock) {
            m2 = ((CompressedMatrixBlock)m2).getUncompressed("Ternary Operator arg2 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
        }
        if (m3 instanceof CompressedMatrixBlock) {
            m3 = ((CompressedMatrixBlock)m3).getUncompressed("Ternary Operator arg3 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
        }
        if (s2 != s3 && (op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply)) {
            BinaryOperator bop = ((TernaryValueFunction.ValueFunctionWithConstant)((Object)op.fn)).setOp2Constant(s2 ? d2 : d3);
            bop.setNumThreads(op.getNumThreads());
            ret = CLALibBinaryCellOp.binaryOperationsRight(bop, m1, s2 ? m3 : m2, ret);
        } else {
            boolean sparseOutput = MatrixBlock.evalSparseFormatInMemory(m, n, (s1 ? (long)(m * n * (d1 != 0.0 ? 1 : 0)) : m1.getNonZeros()) + Math.min(s2 ? (long)(m * n) : m2.getNonZeros(), s3 ? (long)(m * n) : m3.getNonZeros()));
            ret.reset(m, n, sparseOutput);
            MatrixBlock thisUncompressed = m1.getUncompressed("Ternary Operation not supported");
            LibMatrixTercell.tercellOp(thisUncompressed, m2, m3, ret, op);
            ret.examSparsity();
        }
        return ret;
    }
}

