/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.tokenize.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.transform.tokenize.DocumentRepresentation;
import org.apache.sysds.runtime.transform.tokenize.Tokenizer;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.DependencyThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class TokenizerBuilder
implements Serializable {
    private static final long serialVersionUID = -4999630313246644464L;

    public void createInternalRepresentation(FrameBlock in, DocumentRepresentation[] internalRepresentation) {
        this.createInternalRepresentation(in, internalRepresentation, 0, -1);
    }

    public abstract void createInternalRepresentation(FrameBlock var1, DocumentRepresentation[] var2, int var3, int var4);

    public List<DependencyTask<?>> getTasks(FrameBlock in, DocumentRepresentation[] internalRepresentation) {
        int nRows = in.getNumRows();
        ArrayList<TokenizerBuildTask<TokenizerBuilder>> tasks = new ArrayList<TokenizerBuildTask<TokenizerBuilder>>();
        int[] blockSizes = UtilFunctions.getBlockSizes(nRows, Tokenizer.TOKENIZE_NUM_BLOCKS);
        if (blockSizes.length == 1) {
            tasks.add(new TokenizerBuildTask<TokenizerBuilder>(this, in, internalRepresentation, 0, -1));
        } else {
            int startRow = 0;
            for (int i = 0; i < blockSizes.length; ++i) {
                tasks.add(new TokenizerBuildTask<TokenizerBuilder>(this, in, internalRepresentation, startRow, blockSizes[i]));
                startRow += blockSizes[i];
            }
        }
        return DependencyThreadPool.createDependencyTasks(tasks, null);
    }

    protected static class TokenizerBuildTask<T extends TokenizerBuilder>
    implements Callable<Object> {
        protected final T _tokenizerBuilder;
        protected final FrameBlock _input;
        protected final DocumentRepresentation[] _internalRepresentation;
        protected final int _rowStart;
        protected final int _blk;

        protected TokenizerBuildTask(T tokenizerBuilder, FrameBlock input, DocumentRepresentation[] internalRepresentation, int rowStart, int blk) {
            this._tokenizerBuilder = tokenizerBuilder;
            this._input = input;
            this._internalRepresentation = internalRepresentation;
            this._rowStart = rowStart;
            this._blk = blk;
        }

        @Override
        public Object call() throws Exception {
            ((TokenizerBuilder)this._tokenizerBuilder).createInternalRepresentation(this._input, this._internalRepresentation, this._rowStart, this._blk);
            return null;
        }
    }
}

