/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

public class MemoryEstimates {
    public static double bitSetCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += MemoryEstimates.longArrayCost(length / 64L + (long)(length % 64L > 0L ? 1 : 0));
        size += 4.0;
        size += 1.0;
        return size += 3.0;
    }

    public static double booleanArrayCost(long length) {
        return MemoryEstimates.byteArrayCost(length);
    }

    public static double byteArrayCost(long length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 4L) {
            size += 4L;
        } else {
            size += length;
            double diff = (length - 4L) % 8L;
            if (diff > 0.0) {
                size = (long)((double)size + (8.0 - diff));
            }
        }
        return size;
    }

    public static double charArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        if (length <= 2L) {
            size += 4.0;
        } else {
            size += (double)(length * 2L);
            double diff = (length * 2L - 4L) % 8L;
            if (diff > 0.0) {
                size += 8.0 - diff;
            }
        }
        return size;
    }

    public static double intArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        if (length <= 1L) {
            size += 4.0;
        } else {
            size += 4.0 * (double)length;
            if (length % 2L == 0L) {
                size += 4.0;
            }
        }
        return size;
    }

    public static double floatArrayCost(long length) {
        return MemoryEstimates.intArrayCost(length);
    }

    public static final double doubleArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        size += 4.0;
        return size += 8.0 * (double)length;
    }

    public static final double objectArrayCost(long length) {
        double size = 0.0;
        size += 8.0;
        size += 20.0;
        size += 4.0;
        return size += 8.0 * (double)length;
    }

    public static final double longArrayCost(long length) {
        return MemoryEstimates.doubleArrayCost(length);
    }

    public static final double stringArrayCost(String[] strings) {
        int i;
        double size = 0.0;
        int by8 = strings.length - strings.length % 8;
        for (i = 0; i < by8; i += 8) {
            size += MemoryEstimates.stringArrayCostVec8(strings, i);
        }
        while (i < strings.length) {
            size += (double)MemoryEstimates.stringCost(strings[i]);
            ++i;
        }
        return size;
    }

    private static final double stringArrayCostVec8(String[] strings, int r) {
        long size = 0L;
        size += MemoryEstimates.stringCost(strings[r]);
        size += MemoryEstimates.stringCost(strings[r + 1]);
        size += MemoryEstimates.stringCost(strings[r + 2]);
        size += MemoryEstimates.stringCost(strings[r + 3]);
        size += MemoryEstimates.stringCost(strings[r + 4]);
        size += MemoryEstimates.stringCost(strings[r + 5]);
        size += MemoryEstimates.stringCost(strings[r + 6]);
        return size += MemoryEstimates.stringCost(strings[r + 7]);
    }

    public static final double stringArrayCost(int length, int avgStringLength) {
        return (double)(MemoryEstimates.stringCost(avgStringLength) * (long)length) + 24.0;
    }

    public static long stringCost(String value) {
        return value == null ? 24L : MemoryEstimates.stringCost(value.length());
    }

    public static long stringCost(long length) {
        return 60L + length * 2L;
    }
}

