/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteAlgebraicSimplificationStatic
extends HopRewriteRule {
    private static final Types.AggOp[] LOOKUP_VALID_ROW_COL_AGGREGATE = new Types.AggOp[]{Types.AggOp.SUM, Types.AggOp.SUM_SQ, Types.AggOp.MIN, Types.AggOp.MAX, Types.AggOp.MEAN, Types.AggOp.VAR};
    private static final Types.OpOp2[] LOOKUP_VALID_DISTRIBUTIVE_BINARY = new Types.OpOp2[]{Types.OpOp2.PLUS, Types.OpOp2.MINUS};
    private static final Types.OpOp2[] LOOKUP_VALID_ASSOCIATIVE_BINARY = new Types.OpOp2[]{Types.OpOp2.PLUS, Types.OpOp2.MULT};
    private static final Types.OpOp2[] LOOKUP_VALID_SCALAR_BINARY = new Types.OpOp2[]{Types.OpOp2.AND, Types.OpOp2.DIV, Types.OpOp2.EQUAL, Types.OpOp2.GREATER, Types.OpOp2.GREATEREQUAL, Types.OpOp2.INTDIV, Types.OpOp2.LESS, Types.OpOp2.LESSEQUAL, Types.OpOp2.LOG, Types.OpOp2.MAX, Types.OpOp2.MIN, Types.OpOp2.MINUS, Types.OpOp2.MODULUS, Types.OpOp2.MULT, Types.OpOp2.NOTEQUAL, Types.OpOp2.OR, Types.OpOp2.PLUS, Types.OpOp2.POW};

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return roots;
        }
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, false);
        }
        Hop.resetVisitStatus(roots, true);
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, true);
        }
        Hop.resetVisitStatus(roots, true);
        RewriteAlgebraicSimplificationStatic.removeTWriteTReadPairs(roots);
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return root;
        }
        this.rule_AlgebraicSimplification(root, false);
        root.resetVisitStatus();
        this.rule_AlgebraicSimplification(root, true);
        return root;
    }

    private void rule_AlgebraicSimplification(Hop hop, boolean descendFirst) {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput().get(i);
            if (descendFirst) {
                this.rule_AlgebraicSimplification(hi, descendFirst);
            }
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryVectorizeOperation(hi);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryBinaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.fuseDatagenAndBinaryOperation(hi);
            hi = RewriteAlgebraicSimplificationStatic.fuseDatagenAndMinusOperation(hi);
            hi = RewriteAlgebraicSimplificationStatic.foldMultipleAppendOperations(hi);
            hi = RewriteAlgebraicSimplificationStatic.simplifyBinaryToUnaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.canonicalizeMatrixMultScalarAdd(hi);
            hi = RewriteAlgebraicSimplificationStatic.simplifyCTableWithConstMatrixInputs(hi);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryCTable(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyReverseOperation(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationStatic.simplifyMultiBinaryToBinaryOperation(hi);
            }
            hi = RewriteAlgebraicSimplificationStatic.simplifyDistributiveBinaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyBushyBinaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyUnaryAggReorgOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryAggregates(hi);
            hi = RewriteAlgebraicSimplificationStatic.simplifyBinaryMatrixScalarOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.pushdownUnaryAggTransposeOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.pushdownCSETransposeScalarOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.pushdownSumBinaryMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyUnaryPPredOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyTransposedAppend(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationStatic.fuseBinarySubDAGToUnaryOperation(hop, hi, i);
            }
            hi = RewriteAlgebraicSimplificationStatic.simplifyTraceMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifySlicedMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyListIndexing(hi);
            hi = RewriteAlgebraicSimplificationStatic.simplifyConstantSort(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyOrderedSort(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.fuseOrderOperationChain(hi);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryReorgOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryRemoveEmpty(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyTransposeAggBinBinaryChains(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyReplaceZeroOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.removeUnnecessaryMinus(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyGroupedAggregate(hi);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationStatic.fuseMinusNzBinaryOperation(hop, hi, i);
                hi = RewriteAlgebraicSimplificationStatic.fuseLogNzUnaryOperation(hop, hi, i);
                hi = RewriteAlgebraicSimplificationStatic.fuseLogNzBinaryOperation(hop, hi, i);
            }
            hi = RewriteAlgebraicSimplificationStatic.simplifyOuterSeqExpand(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyBinaryComparisonChain(hop, hi, i);
            hi = RewriteAlgebraicSimplificationStatic.simplifyCumsumColOrFullAggregates(hi);
            hi = RewriteAlgebraicSimplificationStatic.simplifyCumsumReverse(hop, hi, i);
            if (descendFirst) continue;
            this.rule_AlgebraicSimplification(hi, descendFirst);
        }
        hop.setVisited();
    }

    private static Hop removeUnnecessaryVectorizeOperation(Hop hi) {
        if (hi instanceof BinaryOp && hi.getDataType() == Types.DataType.MATRIX && ((BinaryOp)hi).supportsMatrixScalarOperations()) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (left.getDim1() <= 1L || left.getDim2() != 1L || right.getDim1() != 1L || right.getDim2() <= 1L) {
                DataGenOp dleft;
                if (left.getDataType() == Types.DataType.MATRIX && right instanceof DataGenOp) {
                    DataGenOp dright = (DataGenOp)right;
                    if (dright.getOp() == Types.OpOpDG.RAND && dright.hasConstantValue()) {
                        Hop drightIn = dright.getInput().get(dright.getParamIndex("min"));
                        HopRewriteUtils.replaceChildReference(bop, dright, drightIn, 1);
                        HopRewriteUtils.cleanupUnreferenced(dright);
                        LOG.debug((Object)"Applied removeUnnecessaryVectorizeOperation1");
                    }
                } else if (right.getDataType() == Types.DataType.MATRIX && left instanceof DataGenOp && (dleft = (DataGenOp)left).getOp() == Types.OpOpDG.RAND && dleft.hasConstantValue() && (left.getDim2() == 1L || right.getDim2() > 1L) && (left.getDim1() == 1L || right.getDim1() > 1L)) {
                    Hop dleftIn = dleft.getInput().get(dleft.getParamIndex("min"));
                    HopRewriteUtils.replaceChildReference(bop, dleft, dleftIn, 0);
                    HopRewriteUtils.cleanupUnreferenced(dleft);
                    LOG.debug((Object)"Applied removeUnnecessaryVectorizeOperation2");
                }
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (left.getDataType() == Types.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 1.0) {
                if (bop.getOp() == Types.OpOp2.DIV || bop.getOp() == Types.OpOp2.MULT) {
                    HopRewriteUtils.replaceChildReference(parent, bop, left, pos);
                    hi = left;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation1 (line " + bop.getBeginLine() + ")"));
                }
            } else if (left.getDataType() == Types.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 0.0) {
                if (bop.getOp() == Types.OpOp2.MINUS) {
                    HopRewriteUtils.replaceChildReference(parent, bop, left, pos);
                    hi = left;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation2 (line " + bop.getBeginLine() + ")"));
                }
            } else if (right.getDataType() == Types.DataType.MATRIX && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == 1.0) {
                if (bop.getOp() == Types.OpOp2.MULT) {
                    HopRewriteUtils.replaceChildReference(parent, bop, right, pos);
                    hi = right;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation3 (line " + bop.getBeginLine() + ")"));
                }
            } else if (right.getDataType() == Types.DataType.MATRIX && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == -1.0) {
                if (bop.getOp() == Types.OpOp2.MULT) {
                    bop.setOp(Types.OpOp2.MINUS);
                    HopRewriteUtils.replaceChildReference(bop, left, new LiteralOp(0L), 0);
                    hi = bop;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation4 (line " + bop.getBeginLine() + ")"));
                }
            } else if (left.getDataType() == Types.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == -1.0 && bop.getOp() == Types.OpOp2.MULT) {
                bop.setOp(Types.OpOp2.MINUS);
                HopRewriteUtils.removeChildReferenceByPos(bop, right, 1);
                HopRewriteUtils.addChildReference(bop, new LiteralOp(0L), 0);
                hi = bop;
                LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation5 (line " + bop.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop fuseDatagenAndBinaryOperation(Hop hi) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (HopRewriteUtils.isDataGenOp(left, Types.OpOpDG.RAND) && right instanceof LiteralOp && left.getParent().size() == 1) {
                boolean pdfUniform;
                DataGenOp inputGen = (DataGenOp)left;
                Hop pdf = inputGen.getInput("pdf");
                Hop min = inputGen.getInput("min");
                Hop max = inputGen.getInput("max");
                double sval = ((LiteralOp)right).getDoubleValue();
                boolean bl = pdfUniform = pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue());
                if (HopRewriteUtils.isBinary((Hop)bop, Types.OpOp2.MULT, Types.OpOp2.PLUS, Types.OpOp2.MINUS, Types.OpOp2.DIV) && min instanceof LiteralOp && max instanceof LiteralOp && pdfUniform) {
                    DataGenOp gen = null;
                    switch (bop.getOp()) {
                        case MULT: {
                            gen = HopRewriteUtils.copyDataGenOp(inputGen, sval, 0.0);
                            break;
                        }
                        case PLUS: 
                        case MINUS: {
                            gen = HopRewriteUtils.copyDataGenOp(inputGen, 1.0, sval * (double)(bop.getOp() == Types.OpOp2.MINUS ? -1 : 1));
                            break;
                        }
                        case DIV: {
                            gen = HopRewriteUtils.copyDataGenOp(inputGen, 1.0 / sval, 0.0);
                        }
                    }
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation1 (" + bop.getFilename() + ", line " + bop.getBeginLine() + ")."));
                }
            } else if (right instanceof DataGenOp && ((DataGenOp)right).getOp() == Types.OpOpDG.RAND && left instanceof LiteralOp && right.getParent().size() == 1) {
                boolean pdfUniform;
                DataGenOp inputGen = (DataGenOp)right;
                Hop pdf = inputGen.getInput("pdf");
                Hop min = inputGen.getInput("min");
                Hop max = inputGen.getInput("max");
                double sval = ((LiteralOp)left).getDoubleValue();
                boolean bl = pdfUniform = pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue());
                if ((bop.getOp() == Types.OpOp2.MULT || bop.getOp() == Types.OpOp2.PLUS) && min instanceof LiteralOp && max instanceof LiteralOp && pdfUniform) {
                    DataGenOp gen = null;
                    gen = bop.getOp() == Types.OpOp2.MULT ? HopRewriteUtils.copyDataGenOp(inputGen, sval, 0.0) : HopRewriteUtils.copyDataGenOp(inputGen, 1.0, sval);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation2 (" + bop.getFilename() + ", line " + bop.getBeginLine() + ")."));
                }
            } else if (HopRewriteUtils.isDataGenOp(left, Types.OpOpDG.RAND) && right.getDataType().isScalar() && left.getParent().size() == 1) {
                boolean pdfUniform;
                DataGenOp gen = (DataGenOp)left;
                Hop min = gen.getInput("min");
                Hop max = gen.getInput("max");
                Hop pdf = gen.getInput("pdf");
                boolean bl = pdfUniform = pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue());
                if (HopRewriteUtils.isBinary((Hop)bop, Types.OpOp2.PLUS) && HopRewriteUtils.isLiteralOfValue(min, 0.0) && HopRewriteUtils.isLiteralOfValue(max, 0.0)) {
                    gen.setInput("min", right, true);
                    gen.setInput("max", right, true);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation3a (" + bop.getFilename() + ", line " + bop.getBeginLine() + ")."));
                } else if (HopRewriteUtils.isBinary((Hop)bop, Types.OpOp2.MULT) && (HopRewriteUtils.isLiteralOfValue(min, 0.0) && pdfUniform || HopRewriteUtils.isLiteralOfValue(min, 1.0)) && HopRewriteUtils.isLiteralOfValue(max, 1.0)) {
                    if (HopRewriteUtils.isLiteralOfValue(min, 1.0)) {
                        gen.setInput("min", right, true);
                    }
                    gen.setInput("max", right, true);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation3b (" + bop.getFilename() + ", line " + bop.getBeginLine() + ")."));
                }
            }
        }
        return hi;
    }

    private static Hop fuseDatagenAndMinusOperation(Hop hi) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (right instanceof DataGenOp && ((DataGenOp)right).getOp() == Types.OpOpDG.RAND && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == 0.0) {
                DataGenOp inputGen = (DataGenOp)right;
                HashMap<String, Integer> params = inputGen.getParamIndexMap();
                Hop pdf = right.getInput().get(params.get("pdf"));
                int ixMin = params.get("min");
                int ixMax = params.get("max");
                Hop min = right.getInput().get(ixMin);
                Hop max = right.getInput().get(ixMax);
                if (inputGen.getParent().size() == 1 && min instanceof LiteralOp && max instanceof LiteralOp && pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue())) {
                    double newMinVal = ((LiteralOp)max).getDoubleValue() == 0.0 ? 0.0 : -1.0 * ((LiteralOp)max).getDoubleValue();
                    double newMaxVal = ((LiteralOp)min).getDoubleValue() == 0.0 ? 0.0 : -1.0 * ((LiteralOp)min).getDoubleValue();
                    LiteralOp newMin = new LiteralOp(newMinVal);
                    LiteralOp newMax = new LiteralOp(newMaxVal);
                    HopRewriteUtils.removeChildReferenceByPos(inputGen, min, ixMin);
                    HopRewriteUtils.addChildReference(inputGen, newMin, ixMin);
                    HopRewriteUtils.removeChildReferenceByPos(inputGen, max, ixMax);
                    HopRewriteUtils.addChildReference(inputGen, newMax, ixMax);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, inputGen);
                    }
                    hi = inputGen;
                    LOG.debug((Object)("Applied fuseDatagenAndMinusOperation (line " + bop.getBeginLine() + ")."));
                }
            }
        }
        return hi;
    }

    private static Hop foldMultipleAppendOperations(Hop hi) {
        if (hi.getDataType().isMatrix() && (HopRewriteUtils.isBinary(hi, Types.OpOp2.CBIND, Types.OpOp2.RBIND) || HopRewriteUtils.isNary(hi, Types.OpOpN.CBIND, Types.OpOpN.RBIND))) {
            Types.OpOp2 bop = hi instanceof BinaryOp ? ((BinaryOp)hi).getOp() : Types.OpOp2.valueOf(((NaryOp)hi).getOp().name());
            Types.OpOpN nop = hi instanceof NaryOp ? ((NaryOp)hi).getOp() : Types.OpOpN.valueOf(((BinaryOp)hi).getOp().name());
            boolean converged = false;
            while (!converged) {
                Hop first = hi.getInput().stream().filter(h -> HopRewriteUtils.isBinary(h, bop) || HopRewriteUtils.isNary(h, nop)).findFirst().orElse(null);
                if (first != null && first.getParent().size() == 1) {
                    ArrayList<Hop> linputs = new ArrayList<Hop>();
                    for (Hop in : hi.getInput()) {
                        if (in == first) {
                            linputs.addAll(first.getInput());
                            continue;
                        }
                        linputs.add(in);
                    }
                    NaryOp hnew = HopRewriteUtils.createNary(nop, linputs.toArray(new Hop[0]));
                    HopRewriteUtils.removeAllChildReferences(hi);
                    HopRewriteUtils.removeAllChildReferences(first);
                    ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, hi, hnew);
                    }
                    hi = hnew;
                    LOG.debug((Object)("Applied foldMultipleAppendOperations (line " + hi.getBeginLine() + ")."));
                    continue;
                }
                converged = true;
            }
        }
        return hi;
    }

    private static Hop simplifyBinaryToUnaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            Hop right;
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            if (left == (right = hi.getInput().get(1)) && left.getDataType() == Types.DataType.MATRIX) {
                if (bop.getOp() == Types.OpOp2.PLUS) {
                    bop.setOp(Types.OpOp2.MULT);
                    HopRewriteUtils.replaceChildReference(hi, right, new LiteralOp(2L), 1);
                    LOG.debug((Object)("Applied simplifyBinaryToUnaryOperation1 (line " + hi.getBeginLine() + ")."));
                } else if (bop.getOp() == Types.OpOp2.MULT) {
                    bop.setOp(Types.OpOp2.POW);
                    HopRewriteUtils.replaceChildReference(hi, right, new LiteralOp(2L), 1);
                    LOG.debug((Object)("Applied simplifyBinaryToUnaryOperation2 (line " + hi.getBeginLine() + ")."));
                }
            } else if (bop.getOp() == Types.OpOp2.MINUS && HopRewriteUtils.isBinary(left, Types.OpOp2.GREATER) && HopRewriteUtils.isBinary(right, Types.OpOp2.LESS) && left.getInput().get(0) == right.getInput().get(0) && left.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left.getInput().get(1)) == 0.0 && right.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right.getInput().get(1)) == 0.0) {
                UnaryOp uop = HopRewriteUtils.createUnary(left.getInput().get(0), Types.OpOp1.SIGN);
                HopRewriteUtils.replaceChildReference(parent, hi, uop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, left, right);
                hi = uop;
                LOG.debug((Object)("Applied simplifyBinaryToUnaryOperation3 (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop canonicalizeMatrixMultScalarAdd(Hop hi) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (left.getDataType().isScalar() && right instanceof AggBinaryOp && bop.getOp() == Types.OpOp2.PLUS) {
                HopRewriteUtils.removeAllChildReferences(bop);
                HopRewriteUtils.addChildReference(bop, right, 0);
                HopRewriteUtils.addChildReference(bop, left, 1);
                LOG.debug((Object)("Applied canonicalizeMatrixMultScalarAdd1 (line " + hi.getBeginLine() + ")."));
            } else if (right.getDataType().isScalar() && left instanceof AggBinaryOp && bop.getOp() == Types.OpOp2.MINUS) {
                bop.setOp(Types.OpOp2.PLUS);
                HopRewriteUtils.replaceChildReference(bop, right, HopRewriteUtils.createBinaryMinus(right), 1);
                LOG.debug((Object)("Applied canonicalizeMatrixMultScalarAdd2 (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifyCTableWithConstMatrixInputs(Hop hi) {
        if (HopRewriteUtils.isTernary(hi, Types.OpOp3.CTABLE)) {
            for (int i = 1; i < hi.getInput().size(); ++i) {
                Hop inCurr = hi.getInput().get(i);
                if (!HopRewriteUtils.isDataGenOpWithConstantValue(inCurr)) continue;
                Hop inNew = ((DataGenOp)inCurr).getInput("min");
                HopRewriteUtils.replaceChildReference(hi, inCurr, inNew, i);
                LOG.debug((Object)("Applied simplifyCTableWithConstMatrixInputs" + i + " (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryCTable(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.SUM, Types.Direction.RowCol) && HopRewriteUtils.isTernary(hi.getInput().get(0), Types.OpOp3.CTABLE) && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(0).getInput().get(2), 1.0)) {
            Hop matrixInput = hi.getInput().get(0).getInput().get(0);
            Types.OpOp1 opcode = matrixInput.getDim2() == 1L ? Types.OpOp1.NROW : Types.OpOp1.LENGTH;
            UnaryOp newOpLength = new UnaryOp("tmp", Types.DataType.SCALAR, Types.ValueType.INT64, opcode, matrixInput);
            HopRewriteUtils.replaceChildReference(parent, hi, newOpLength, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi.getInput().get(0));
            hi = newOpLength;
        }
        return hi;
    }

    private static Hop simplifyReverseOperation(Hop parent, Hop hi, int pos) {
        TernaryOp top;
        if (hi instanceof AggBinaryOp && hi.getInput().get(0) instanceof TernaryOp && (top = (TernaryOp)hi.getInput().get(0)).getOp() == Types.OpOp3.CTABLE && HopRewriteUtils.isBasic1NSequence(top.getInput().get(0)) && HopRewriteUtils.isBasicN1Sequence(top.getInput().get(1)) && top.getInput().get(0).getDim1() == top.getInput().get(1).getDim1()) {
            ReorgOp rop = HopRewriteUtils.createReorg(hi.getInput().get(1), Types.ReOrgOp.REV);
            HopRewriteUtils.replaceChildReference(parent, hi, rop, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, top);
            hi = rop;
            LOG.debug((Object)"Applied simplifyReverseOperation.");
        }
        return hi;
    }

    private static Hop simplifyMultiBinaryToBinaryOperation(Hop hi) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MINUS) && hi.getDataType() == Types.DataType.MATRIX && hi.getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)hi.getInput().get(0)) == 1.0 && HopRewriteUtils.isBinary(hi.getInput().get(1), Types.OpOp2.MULT) && hi.getInput().get(1).getParent().size() == 1) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(1).getInput().get(0);
            Hop right = hi.getInput().get(1).getInput().get(1);
            bop.setOp(Types.OpOp2.MINUS1_MULT);
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.addChildReference(bop, left);
            HopRewriteUtils.addChildReference(bop, right);
            LOG.debug((Object)"Applied simplifyMultiBinaryToBinaryOperation.");
        }
        return hi;
    }

    private static Hop simplifyDistributiveBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            boolean applied = false;
            if (left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isValidOp(bop.getOp(), LOOKUP_VALID_DISTRIBUTIVE_BINARY)) {
                BinaryOp mult;
                BinaryOp plus;
                LiteralOp literal;
                Hop X = null;
                Hop Y = null;
                if (HopRewriteUtils.isBinary(left, Types.OpOp2.MULT)) {
                    Hop leftC1 = left.getInput().get(0);
                    Hop leftC2 = left.getInput().get(1);
                    if (leftC1.getDataType() == Types.DataType.MATRIX && leftC2.getDataType() == Types.DataType.MATRIX && (right == leftC1 || right == leftC2) && leftC1 != leftC2) {
                        X = right;
                        Hop hop = Y = right == leftC1 ? leftC2 : leftC1;
                    }
                    if (X != null) {
                        literal = new LiteralOp(1L);
                        plus = HopRewriteUtils.createBinary(Y, (Hop)literal, bop.getOp());
                        mult = HopRewriteUtils.createBinary((Hop)plus, X, Types.OpOp2.MULT);
                        HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, left);
                        hi = mult;
                        applied = true;
                        LOG.debug((Object)("Applied simplifyDistributiveBinaryOperation1 (line " + hi.getBeginLine() + ")."));
                    }
                }
                if (!applied && HopRewriteUtils.isBinary(right, Types.OpOp2.MULT)) {
                    Hop rightC1 = right.getInput().get(0);
                    Hop rightC2 = right.getInput().get(1);
                    if (rightC1.getDataType() == Types.DataType.MATRIX && rightC2.getDataType() == Types.DataType.MATRIX && (left == rightC1 || left == rightC2) && rightC1 != rightC2) {
                        X = left;
                        Hop hop = Y = left == rightC1 ? rightC2 : rightC1;
                    }
                    if (X != null) {
                        literal = new LiteralOp(1L);
                        plus = HopRewriteUtils.createBinary((Hop)literal, Y, bop.getOp());
                        mult = HopRewriteUtils.createBinary((Hop)plus, X, Types.OpOp2.MULT);
                        HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, right);
                        hi = mult;
                        LOG.debug((Object)("Applied simplifyDistributiveBinaryOperation2 (line " + hi.getBeginLine() + ")."));
                    }
                }
            }
        }
        return hi;
    }

    private static Hop simplifyBushyBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp && parent instanceof AggBinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            Types.OpOp2 op = bop.getOp();
            if (left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isValidOp(op, LOOKUP_VALID_ASSOCIATIVE_BINARY)) {
                BinaryOp bop4;
                BinaryOp bop3;
                Types.OpOp2 op2;
                Hop right2;
                Hop left2;
                BinaryOp bop2;
                boolean applied = false;
                if (right instanceof BinaryOp) {
                    bop2 = (BinaryOp)right;
                    left2 = bop2.getInput().get(0);
                    right2 = bop2.getInput().get(1);
                    op2 = bop2.getOp();
                    if (op == op2 && right2.getDataType() == Types.DataType.MATRIX && right2 instanceof AggBinaryOp) {
                        bop3 = HopRewriteUtils.createBinary(left, left2, op);
                        bop4 = HopRewriteUtils.createBinary((Hop)bop3, right2, op);
                        HopRewriteUtils.replaceChildReference(parent, bop, bop4, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, bop2);
                        hi = bop4;
                        applied = true;
                        LOG.debug((Object)"Applied simplifyBushyBinaryOperation1");
                    }
                }
                if (!applied && left instanceof BinaryOp) {
                    bop2 = (BinaryOp)left;
                    left2 = bop2.getInput().get(0);
                    right2 = bop2.getInput().get(1);
                    op2 = bop2.getOp();
                    if (!(op != op2 || left2.getDataType() != Types.DataType.MATRIX || !(left2 instanceof AggBinaryOp) || right2.getDim2() <= 1L && right.getDim2() != 1L || right2.getDim1() <= 1L && right.getDim1() != 1L)) {
                        bop3 = HopRewriteUtils.createBinary(right2, right, op);
                        bop4 = HopRewriteUtils.createBinary(left2, (Hop)bop3, op);
                        HopRewriteUtils.replaceChildReference(parent, bop, bop4, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, bop2);
                        hi = bop4;
                        LOG.debug((Object)"Applied simplifyBushyBinaryOperation2");
                    }
                }
            }
        }
        return hi;
    }

    private static Hop simplifyUnaryAggReorgOperation(Hop parent, Hop hi, int pos) {
        ReorgOp rop;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && hi.getInput().get(0) instanceof ReorgOp && ((rop = (ReorgOp)hi.getInput().get(0)).getOp() == Types.ReOrgOp.TRANS || rop.getOp() == Types.ReOrgOp.RESHAPE || rop.getOp() == Types.ReOrgOp.REV) && rop.getParent().size() == 1) {
            Hop input = rop.getInput().get(0);
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.removeAllChildReferences(rop);
            HopRewriteUtils.addChildReference(hi, input);
            LOG.debug((Object)"Applied simplifyUnaryAggReorgOperation");
        }
        return hi;
    }

    private static Hop removeUnnecessaryAggregates(Hop hi) {
        if (hi instanceof AggUnaryOp && hi.getInput().get(0) instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && hi.getInput().get(0).getParent().size() == 1) {
            AggUnaryOp au1 = (AggUnaryOp)hi;
            AggUnaryOp au2 = (AggUnaryOp)hi.getInput().get(0);
            if (au1.getOp() == Types.AggOp.SUM && (au2.getOp() == Types.AggOp.SUM || au2.getOp() == Types.AggOp.SUM_SQ) || au1.getOp() == Types.AggOp.MIN && au2.getOp() == Types.AggOp.MIN || au1.getOp() == Types.AggOp.MAX && au2.getOp() == Types.AggOp.MAX) {
                Hop input = au2.getInput().get(0);
                HopRewriteUtils.removeAllChildReferences(au2);
                HopRewriteUtils.replaceChildReference(au1, au2, input);
                if (au2.getOp() == Types.AggOp.SUM_SQ) {
                    au1.setOp(Types.AggOp.SUM_SQ);
                }
                LOG.debug((Object)("Applied removeUnnecessaryAggregates (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifyBinaryMatrixScalarOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isUnary(hi, Types.OpOp1.CAST_AS_SCALAR) && hi.getInput().get(0) instanceof BinaryOp && HopRewriteUtils.isBinary(hi.getInput().get(0), LOOKUP_VALID_SCALAR_BINARY)) {
            BinaryOp bin = (BinaryOp)hi.getInput().get(0);
            BinaryOp bout = null;
            if (bin.getInput().get(0).getDataType() == Types.DataType.MATRIX && bin.getInput().get(1).getDataType() == Types.DataType.MATRIX) {
                UnaryOp cast1 = HopRewriteUtils.createUnary(bin.getInput().get(0), Types.OpOp1.CAST_AS_SCALAR);
                UnaryOp cast2 = HopRewriteUtils.createUnary(bin.getInput().get(1), Types.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary((Hop)cast1, (Hop)cast2, bin.getOp());
            } else if (bin.getInput().get(0).getDataType() == Types.DataType.MATRIX) {
                UnaryOp cast = HopRewriteUtils.createUnary(bin.getInput().get(0), Types.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary((Hop)cast, bin.getInput().get(1), bin.getOp());
            } else if (bin.getInput().get(1).getDataType() == Types.DataType.MATRIX) {
                UnaryOp cast = HopRewriteUtils.createUnary(bin.getInput().get(1), Types.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary(bin.getInput().get(0), (Hop)cast, bin.getOp());
            }
            if (bout != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, bout, pos);
                LOG.debug((Object)"Applied simplifyBinaryMatrixScalarOperation.");
            }
        }
        return hi;
    }

    private static Hop pushdownUnaryAggTransposeOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && hi.getParent().size() == 1 && (((AggUnaryOp)hi).getDirection() == Types.Direction.Row || ((AggUnaryOp)hi).getDirection() == Types.Direction.Col) && HopRewriteUtils.isTransposeOperation(hi.getInput().get(0), 1) && HopRewriteUtils.isValidOp(((AggUnaryOp)hi).getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE)) {
            AggUnaryOp uagg = (AggUnaryOp)hi;
            Hop input = uagg.getInput().get(0).getInput().get(0);
            HopRewriteUtils.removeAllChildReferences(hi.getInput().get(0));
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.removeChildReferenceByPos(parent, hi, pos);
            if (uagg.getDirection() == Types.Direction.Row) {
                uagg.setDirection(Types.Direction.Col);
                LOG.debug((Object)("Applied pushdownUnaryAggTransposeOperation1 (line " + hi.getBeginLine() + ")."));
            } else if (uagg.getDirection() == Types.Direction.Col) {
                uagg.setDirection(Types.Direction.Row);
                LOG.debug((Object)("Applied pushdownUnaryAggTransposeOperation2 (line " + hi.getBeginLine() + ")."));
            }
            HopRewriteUtils.addChildReference(uagg, input);
            uagg.refreshSizeInformation();
            ReorgOp trans = HopRewriteUtils.createTranspose(uagg);
            HopRewriteUtils.addChildReference(parent, trans, pos);
            hi = trans;
        }
        return hi;
    }

    private static Hop pushdownCSETransposeScalarOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isTransposeOperation(hi, 1) && HopRewriteUtils.isBinaryMatrixScalarOperation(hi.getInput().get(0)) && hi.getInput().get(0).getParent().size() == 1) {
            int Xpos = hi.getInput().get(0).getInput().get(0).getDataType().isMatrix() ? 0 : 1;
            Hop X = hi.getInput().get(0).getInput().get(Xpos);
            BinaryOp binary = (BinaryOp)hi.getInput().get(0);
            if (HopRewriteUtils.containsTransposeOperation(X.getParent()) && !HopRewriteUtils.isValidOp(binary.getOp(), Types.OpOp2.MOMENT, Types.OpOp2.QUANTILE)) {
                HopRewriteUtils.removeChildReferenceByPos(parent, hi, pos);
                HopRewriteUtils.removeChildReference(hi, binary);
                HopRewriteUtils.removeChildReference(binary, X);
                HopRewriteUtils.addChildReference(parent, binary, pos);
                HopRewriteUtils.addChildReference(binary, hi, Xpos);
                HopRewriteUtils.addChildReference(hi, X);
                hi = binary;
                LOG.debug((Object)("Applied pushdownCSETransposeScalarOperation (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop pushdownSumBinaryMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && HopRewriteUtils.isBinary(hi.getInput().get(0), Types.OpOp2.MULT, 1) && (hi.getInput().get(0).getInput().get(0).getDataType() == Types.DataType.SCALAR && hi.getInput().get(0).getInput().get(1).getDataType() == Types.DataType.MATRIX || hi.getInput().get(0).getInput().get(0).getDataType() == Types.DataType.MATRIX && hi.getInput().get(0).getInput().get(1).getDataType() == Types.DataType.SCALAR)) {
            Hop operand1 = hi.getInput().get(0).getInput().get(0);
            Hop operand2 = hi.getInput().get(0).getInput().get(1);
            Hop lamda = operand1.getDataType() == Types.DataType.SCALAR ? operand1 : operand2;
            Hop matrix = operand1.getDataType() == Types.DataType.MATRIX ? operand1 : operand2;
            AggUnaryOp aggOp = HopRewriteUtils.createAggUnaryOp(matrix, Types.AggOp.SUM, Types.Direction.RowCol);
            BinaryOp bop = HopRewriteUtils.createBinary(lamda, (Hop)aggOp, Types.OpOp2.MULT);
            HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
            LOG.debug((Object)"Applied pushdownSumBinaryMult.");
            return bop;
        }
        return hi;
    }

    private static Hop simplifyUnaryPPredOperation(Hop parent, Hop hi, int pos) {
        UnaryOp uop;
        if (hi instanceof UnaryOp && hi.getDataType() == Types.DataType.MATRIX && hi.getInput().get(0) instanceof BinaryOp && ((BinaryOp)hi.getInput().get(0)).isPPredOperation() && ((uop = (UnaryOp)hi).getOp() == Types.OpOp1.ABS || uop.getOp() == Types.OpOp1.SIGN || uop.getOp() == Types.OpOp1.CEIL || uop.getOp() == Types.OpOp1.FLOOR || uop.getOp() == Types.OpOp1.ROUND)) {
            Hop input = uop.getInput().get(0);
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)"Applied simplifyUnaryPPredOperation.");
        }
        return hi;
    }

    private static Hop simplifyTransposedAppend(Hop parent, Hop hi, int pos) {
        BinaryOp bop;
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput().get(0) instanceof BinaryOp && (((BinaryOp)hi.getInput().get(0)).getOp() == Types.OpOp2.CBIND || ((BinaryOp)hi.getInput().get(0)).getOp() == Types.OpOp2.RBIND) && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isTransposeOperation((bop = (BinaryOp)hi.getInput().get(0)).getInput().get(0), 1) && HopRewriteUtils.isTransposeOperation(bop.getInput().get(1), 1)) {
            Hop left = bop.getInput().get(0).getInput().get(0);
            Hop right = bop.getInput().get(1).getInput().get(0);
            Types.OpOp2 binop = bop.getOp() == Types.OpOp2.CBIND ? Types.OpOp2.RBIND : Types.OpOp2.CBIND;
            BinaryOp bopnew = HopRewriteUtils.createBinary(left, right, binop);
            HopRewriteUtils.replaceChildReference(parent, hi, bopnew, pos);
            hi = bopnew;
            LOG.debug((Object)("Applied simplifyTransposedAppend (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private static Hop fuseBinarySubDAGToUnaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            Hop right2;
            Hop right1;
            BinaryOp bright;
            Hop left2;
            Hop left1;
            BinaryOp bleft;
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            boolean applied = false;
            if (bop.getOp() == Types.OpOp2.MULT && left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX) {
                UnaryOp unary;
                if (left instanceof BinaryOp) {
                    bleft = (BinaryOp)left;
                    left1 = bleft.getInput().get(0);
                    left2 = bleft.getInput().get(1);
                    if (left1 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left1) == 1.0 && left2 == right && bleft.getOp() == Types.OpOp2.MINUS) {
                        unary = HopRewriteUtils.createUnary(right, Types.OpOp1.SPROP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sprop1");
                    }
                }
                if (!applied && right instanceof BinaryOp) {
                    bright = (BinaryOp)right;
                    right1 = bright.getInput().get(0);
                    right2 = bright.getInput().get(1);
                    if (right1 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right1) == 1.0 && right2 == left && bright.getOp() == Types.OpOp2.MINUS) {
                        unary = HopRewriteUtils.createUnary(left, Types.OpOp1.SPROP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sprop2");
                    }
                }
            }
            if (!applied && bop.getOp() == Types.OpOp2.DIV && left.getDataType() == Types.DataType.SCALAR && right.getDataType() == Types.DataType.MATRIX && left instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left) == 1.0 && right instanceof BinaryOp) {
                BinaryOp bop2 = (BinaryOp)right;
                Hop left22 = bop2.getInput().get(0);
                right2 = bop2.getInput().get(1);
                if (bop2.getOp() == Types.OpOp2.PLUS && left22.getDataType() == Types.DataType.SCALAR && right2.getDataType() == Types.DataType.MATRIX && left22 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left22) == 1.0 && right2 instanceof UnaryOp) {
                    UnaryOp uop = (UnaryOp)right2;
                    Hop uopin = uop.getInput().get(0);
                    if (uop.getOp() == Types.OpOp1.EXP) {
                        UnaryOp unary = null;
                        if (HopRewriteUtils.isBinary(uopin, Types.OpOp2.MINUS)) {
                            BinaryOp bop3 = (BinaryOp)uopin;
                            Hop left3 = bop3.getInput().get(0);
                            Hop right3 = bop3.getInput().get(1);
                            if (left3 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left3) == 0.0) {
                                unary = HopRewriteUtils.createUnary(right3, Types.OpOp1.SIGMOID);
                            }
                        } else {
                            BinaryOp minus = HopRewriteUtils.createBinaryMinus(uopin);
                            unary = HopRewriteUtils.createUnary((Hop)minus, Types.OpOp1.SIGMOID);
                        }
                        if (unary != null) {
                            HopRewriteUtils.replaceChildReference(parent, bop, unary, pos);
                            HopRewriteUtils.cleanupUnreferenced(bop, bop2, uop);
                            hi = unary;
                            applied = true;
                            LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sigmoid1");
                        }
                    }
                }
            }
            if (!applied && bop.getOp() == Types.OpOp2.MULT && left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX) {
                BinaryOp binary;
                if (left instanceof BinaryOp) {
                    bleft = (BinaryOp)left;
                    left1 = bleft.getInput().get(0);
                    left2 = bleft.getInput().get(1);
                    if (left2 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left2) == 0.0 && left1 == right && bleft.getOp() == Types.OpOp2.GREATER) {
                        binary = HopRewriteUtils.createBinary(right, (Hop)new LiteralOp(0L), Types.OpOp2.MAX);
                        HopRewriteUtils.replaceChildReference(parent, bop, binary, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = binary;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-max0a");
                    }
                }
                if (!applied && right instanceof BinaryOp) {
                    bright = (BinaryOp)right;
                    right1 = bright.getInput().get(0);
                    right2 = bright.getInput().get(1);
                    if (right2 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right2) == 0.0 && right1 == left && bright.getOp() == Types.OpOp2.GREATER) {
                        binary = HopRewriteUtils.createBinary(left, (Hop)new LiteralOp(0L), Types.OpOp2.MAX);
                        HopRewriteUtils.replaceChildReference(parent, bop, binary, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = binary;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-max0b");
                    }
                }
            }
        }
        return hi;
    }

    private static Hop simplifyTraceMatrixMult(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Types.AggOp.TRACE && HopRewriteUtils.isMatrixMultiply(hi2 = hi.getInput().get(0))) {
            Hop left = hi2.getInput().get(0);
            Hop right = hi2.getInput().get(1);
            ReorgOp trans = HopRewriteUtils.createTranspose(right);
            BinaryOp mult = HopRewriteUtils.createBinary(left, (Hop)trans, Types.OpOp2.MULT);
            AggUnaryOp sum = HopRewriteUtils.createSum(mult);
            HopRewriteUtils.replaceChildReference(parent, hi, sum, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = sum;
            LOG.debug((Object)"Applied simplifyTraceMatrixMult");
        }
        return hi;
    }

    private static Hop simplifySlicedMatrixMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof IndexingOp && ((IndexingOp)hi).isRowLowerEqualsUpper() && ((IndexingOp)hi).isColLowerEqualsUpper() && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isMatrixMultiply(hi.getInput().get(0))) {
            Hop mm = hi.getInput().get(0);
            Hop X = mm.getInput().get(0);
            Hop Y = mm.getInput().get(1);
            Hop rowExpr = hi.getInput().get(1);
            Hop colExpr = hi.getInput().get(3);
            HopRewriteUtils.removeAllChildReferences(mm);
            IndexingOp ix1 = new IndexingOp("tmp1", Types.DataType.MATRIX, Types.ValueType.FP64, X, rowExpr, rowExpr, new LiteralOp(1L), HopRewriteUtils.createValueHop(X, false), true, false);
            ix1.setBlocksize(X.getBlocksize());
            ix1.refreshSizeInformation();
            IndexingOp ix2 = new IndexingOp("tmp2", Types.DataType.MATRIX, Types.ValueType.FP64, Y, new LiteralOp(1L), HopRewriteUtils.createValueHop(Y, true), colExpr, colExpr, false, true);
            ix2.setBlocksize(Y.getBlocksize());
            ix2.refreshSizeInformation();
            HopRewriteUtils.addChildReference(mm, ix1, 0);
            HopRewriteUtils.addChildReference(mm, ix2, 1);
            mm.refreshSizeInformation();
            hi = mm;
            LOG.debug((Object)"Applied simplifySlicedMatrixMult");
        }
        return hi;
    }

    private static Hop simplifyListIndexing(Hop hi) {
        if (hi instanceof IndexingOp && hi.getDataType().isList() && !(hi.getInput(4) instanceof LiteralOp)) {
            HopRewriteUtils.replaceChildReference(hi, hi.getInput(4), new LiteralOp(1L));
            LOG.debug((Object)("Applied simplifyListIndexing (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private static Hop simplifyConstantSort(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Types.ReOrgOp.SORT && (hi2 = hi.getInput().get(0)) instanceof DataGenOp && ((DataGenOp)hi2).getOp() == Types.OpOpDG.RAND && ((DataGenOp)hi2).hasConstantValue() && hi.getInput().get(3) instanceof LiteralOp) {
            if (HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(3))) {
                DataGenOp seq = HopRewriteUtils.createSeqDataGenOp(hi2);
                ((Hop)seq).refreshSizeInformation();
                HopRewriteUtils.replaceChildReference(parent, hi, seq, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = seq;
                LOG.debug((Object)"Applied simplifyConstantSort1.");
            } else {
                HopRewriteUtils.replaceChildReference(parent, hi, hi2, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hi2;
                LOG.debug((Object)"Applied simplifyConstantSort2.");
            }
        }
        return hi;
    }

    private static Hop simplifyOrderedSort(Hop parent, Hop hi, int pos) {
        Hop incr;
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Types.ReOrgOp.SORT && (hi2 = hi.getInput().get(0)) instanceof DataGenOp && ((DataGenOp)hi2).getOp() == Types.OpOpDG.SEQ && (incr = hi2.getInput().get(((DataGenOp)hi2).getParamIndex("incr"))) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)incr) == 1.0 && hi.getInput().get(2) instanceof LiteralOp && hi.getInput().get(3) instanceof LiteralOp) {
            if (HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(3))) {
                boolean desc = HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(2));
                DataGenOp seq = HopRewriteUtils.createSeqDataGenOp(hi2, !desc);
                ((Hop)seq).refreshSizeInformation();
                HopRewriteUtils.replaceChildReference(parent, hi, seq, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = seq;
                LOG.debug((Object)"Applied simplifyOrderedSort1.");
            } else if (!HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(2))) {
                HopRewriteUtils.replaceChildReference(parent, hi, hi2, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hi2;
                LOG.debug((Object)"Applied simplifyOrderedSort2.");
            }
        }
        return hi;
    }

    private static Hop fuseOrderOperationChain(Hop hi) {
        if (HopRewriteUtils.isReorg(hi, Types.ReOrgOp.SORT) && hi.getInput().get(1) instanceof LiteralOp && hi.getInput().get(2) instanceof LiteralOp && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(3), false)) {
            LiteralOp by = (LiteralOp)hi.getInput().get(1);
            boolean desc = HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(2));
            HashSet<String> probe = new HashSet<String>();
            ArrayList<LiteralOp> byList = new ArrayList<LiteralOp>();
            byList.add(by);
            probe.add(by.getStringValue());
            Hop input = hi.getInput().get(0);
            while (HopRewriteUtils.isReorg(input, Types.ReOrgOp.SORT) && input.getInput().get(1) instanceof LiteralOp && !probe.contains(input.getInput().get(1).getName()) && HopRewriteUtils.isLiteralOfValue(input.getInput().get(2), desc) && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(3), false) && input.getParent().size() == 1) {
                byList.add((LiteralOp)input.getInput().get(1));
                probe.add(input.getInput().get(1).getName());
                input = input.getInput().get(0);
            }
            if (byList.size() >= 2) {
                ArrayList<Hop> inputs = new ArrayList<Hop>();
                inputs.add(input);
                inputs.add(HopRewriteUtils.createDataGenOpByVal(byList, 1L, byList.size()));
                inputs.add(new LiteralOp(desc));
                inputs.add(new LiteralOp(false));
                ReorgOp hnew = HopRewriteUtils.createReorg(inputs, Types.ReOrgOp.SORT);
                Hop current = hi;
                while (current != input) {
                    Hop tmp = current.getInput().get(0);
                    HopRewriteUtils.removeAllChildReferences(current);
                    current = tmp;
                }
                ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                for (Hop p : parents) {
                    HopRewriteUtils.replaceChildReference(p, hi, hnew);
                }
                hi = hnew;
                LOG.debug((Object)("Applied fuseOrderOperationChain (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifyTransposeAggBinBinaryChains(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput().get(0) instanceof BinaryOp && ((BinaryOp)hi.getInput().get(0)).supportsMatrixScalarOperations()) {
            Hop left = hi.getInput().get(0).getInput().get(0);
            Hop C = hi.getInput().get(0).getInput().get(1);
            if (left instanceof AggBinaryOp && C.getDataType().isMatrix() && HopRewriteUtils.isTransposeOperation(left.getInput().get(0)) && left.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isTransposeOperation(left.getInput().get(1)) && left.getInput().get(1).getParent().size() == 1) {
                Hop A = left.getInput().get(0).getInput().get(0);
                Hop B = left.getInput().get(1).getInput().get(0);
                AggBinaryOp abop = HopRewriteUtils.createMatrixMultiply(B, A);
                ReorgOp rop = HopRewriteUtils.createTranspose(C);
                BinaryOp bop = HopRewriteUtils.createBinary((Hop)abop, (Hop)rop, Types.OpOp2.PLUS);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                LOG.debug((Object)("Applied simplifyTransposeAggBinBinaryChains (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifyReplaceZeroOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.PLUS) && hi.getInput().get(0).isMatrix() && HopRewriteUtils.isBinary(hi.getInput().get(1), Types.OpOp2.MULT) && hi.getInput().get(1).getInput().get(1).isScalar() && HopRewriteUtils.isBinaryMatrixScalar(hi.getInput().get(1).getInput().get(0), Types.OpOp2.EQUAL, 0.0) && hi.getInput().get(1).getInput().get(0).getInput().contains(hi.getInput().get(0))) {
            LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
            args.put("target", hi.getInput().get(0));
            args.put("pattern", new LiteralOp(0L));
            args.put("replacement", hi.getInput().get(1).getInput().get(1));
            ParameterizedBuiltinOp replace = HopRewriteUtils.createParameterizedBuiltinOp(hi.getInput().get(0), args, Types.ParamBuiltinOp.REPLACE);
            HopRewriteUtils.replaceChildReference(parent, hi, replace, pos);
            hi = replace;
            LOG.debug((Object)("Applied simplifyReplaceZeroOperation (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private static Hop removeUnnecessaryReorgOperation(Hop parent, Hop hi, int pos) {
        Types.ReOrgOp[] lookup = new Types.ReOrgOp[]{Types.ReOrgOp.TRANS, Types.ReOrgOp.REV};
        if (hi instanceof ReorgOp && HopRewriteUtils.isValidOp(((ReorgOp)hi).getOp(), lookup)) {
            Types.ReOrgOp firstOp = ((ReorgOp)hi).getOp();
            Hop hi2 = hi.getInput().get(0);
            if (hi2 instanceof ReorgOp && ((ReorgOp)hi2).getOp() == firstOp) {
                Hop hi3 = hi2.getInput().get(0);
                HopRewriteUtils.replaceChildReference(parent, hi, hi3, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, hi2);
                hi = hi3;
                LOG.debug((Object)"Applied removeUnecessaryReorgOperation.");
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryRemoveEmpty(Hop parent, Hop hi, int pos) {
        if ((HopRewriteUtils.isSum(hi) || HopRewriteUtils.isSumSq(hi)) && HopRewriteUtils.isRemoveEmpty(hi.getInput().get(0)) && hi.getInput().get(0).getParent().size() == 1) {
            Hop input;
            boolean needRmEmpty;
            AggUnaryOp agg = (AggUnaryOp)hi;
            ParameterizedBuiltinOp rmEmpty = (ParameterizedBuiltinOp)hi.getInput().get(0);
            boolean bl = needRmEmpty = agg.getDirection() == Types.Direction.Row && HopRewriteUtils.isRemoveEmpty(rmEmpty, true) || agg.getDirection() == Types.Direction.Col && HopRewriteUtils.isRemoveEmpty(rmEmpty, false);
            if (rmEmpty.getParameterHop("select") == null && !needRmEmpty && (input = rmEmpty.getTargetHop()) != null) {
                HopRewriteUtils.replaceChildReference(hi, rmEmpty, input);
                return hi;
            }
        }
        if (HopRewriteUtils.isUnary(hi, Types.OpOp1.NROW) && HopRewriteUtils.isRemoveEmpty(hi.getInput().get(0), true) && hi.getInput().get(0).getParent().size() == 1) {
            Hop input;
            ParameterizedBuiltinOp rm = (ParameterizedBuiltinOp)hi.getInput().get(0);
            Hop hop = rm.getParameterHop("select") != null ? rm.getParameterHop("select") : (input = rm.getDim2() == 1L ? rm.getTargetHop() : null);
            if (input != null) {
                HopRewriteUtils.removeAllChildReferences(rm);
                Hop hnew = HopRewriteUtils.createComputeNnz(input);
                if (hnew != null) {
                    HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                    hi = hnew;
                    LOG.debug((Object)("Applied removeUnnecessaryRemoveEmpty (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryMinus(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi.getDataType() == Types.DataType.MATRIX && hi instanceof BinaryOp && ((BinaryOp)hi).getOp() == Types.OpOp2.MINUS && hi.getInput().get(0) instanceof LiteralOp && ((LiteralOp)hi.getInput().get(0)).getDoubleValue() == 0.0 && (hi2 = hi.getInput().get(1)).getDataType() == Types.DataType.MATRIX && hi2 instanceof BinaryOp && ((BinaryOp)hi2).getOp() == Types.OpOp2.MINUS && hi2.getInput().get(0) instanceof LiteralOp && ((LiteralOp)hi2.getInput().get(0)).getDoubleValue() == 0.0) {
            Hop hi3 = hi2.getInput().get(1);
            HopRewriteUtils.replaceChildReference(parent, hi, hi3, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = hi3;
            LOG.debug((Object)"Applied removeUnecessaryMinus");
        }
        return hi;
    }

    private static Hop simplifyGroupedAggregate(Hop hi) {
        int ix2;
        HashMap<String, Integer> params;
        int ix1;
        ParameterizedBuiltinOp phi;
        if (hi instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)hi).getOp() == Types.ParamBuiltinOp.GROUPEDAGG && (phi = (ParameterizedBuiltinOp)hi).isCountFunction() && phi.getTargetHop().getDim2() == 1L && (ix1 = (params = phi.getParamIndexMap()).get("target").intValue()) != (ix2 = params.get("groups").intValue()) && phi.getInput().get(ix1) != phi.getInput().get(ix2)) {
            Hop th = phi.getInput().get(ix1);
            Hop gh = phi.getInput().get(ix2);
            HopRewriteUtils.replaceChildReference(hi, th, gh, ix1);
            LOG.debug((Object)"Applied simplifyGroupedAggregateCount");
        }
        return hi;
    }

    private static Hop fuseMinusNzBinaryOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MINUS) && hi.getInput().get(0).getDataType() == Types.DataType.MATRIX && hi.getInput().get(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isBinary(hi.getInput().get(1), Types.OpOp2.MULT)) {
            Hop X = hi.getInput().get(0);
            Hop s = hi.getInput().get(1).getInput().get(0);
            Hop pred = hi.getInput().get(1).getInput().get(1);
            if (s.getDataType() == Types.DataType.SCALAR && pred.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isBinary(pred, Types.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                BinaryOp hnew = HopRewriteUtils.createBinary(X, s, Types.OpOp2.MINUS_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseMinusNzBinaryOperation (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop fuseLogNzUnaryOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MULT) && hi.getInput().get(0).getDataType() == Types.DataType.MATRIX && hi.getInput().get(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isUnary(hi.getInput().get(1), Types.OpOp1.LOG)) {
            Hop pred = hi.getInput().get(0);
            Hop X = hi.getInput().get(1).getInput().get(0);
            if (HopRewriteUtils.isBinary(pred, Types.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                UnaryOp hnew = HopRewriteUtils.createUnary(X, Types.OpOp1.LOG_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseLogNzUnaryOperation (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop fuseLogNzBinaryOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MULT) && hi.getInput().get(0).getDataType() == Types.DataType.MATRIX && hi.getInput().get(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isBinary(hi.getInput().get(1), Types.OpOp2.LOG)) {
            Hop pred = hi.getInput().get(0);
            Hop X = hi.getInput().get(1).getInput().get(0);
            Hop log = hi.getInput().get(1).getInput().get(1);
            if (HopRewriteUtils.isBinary(pred, Types.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                BinaryOp hnew = HopRewriteUtils.createBinary(X, log, Types.OpOp2.LOG_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseLogNzBinaryOperation (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop simplifyOuterSeqExpand(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.EQUAL) && ((BinaryOp)hi).isOuter() && (HopRewriteUtils.isTransposeOperation(hi.getInput().get(1)) && HopRewriteUtils.isBasic1NSequence(hi.getInput().get(1).getInput().get(0)) || HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0)))) {
            boolean isPatternB = HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0));
            boolean isTransposeRight = HopRewriteUtils.isTransposeOperation(hi.getInput().get(1));
            Hop trgt = isPatternB ? (isTransposeRight ? hi.getInput().get(1).getInput().get(0) : HopRewriteUtils.createTranspose(hi.getInput().get(1))) : hi.getInput().get(0);
            Hop seq = isPatternB ? hi.getInput().get(0) : hi.getInput().get(1).getInput().get(0);
            String direction = HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0)) ? "rows" : "cols";
            LinkedHashMap<String, Hop> inputargs = new LinkedHashMap<String, Hop>();
            inputargs.put("target", trgt);
            inputargs.put("max", HopRewriteUtils.getBasic1NSequenceMax(seq));
            inputargs.put("dir", new LiteralOp(direction));
            inputargs.put("ignore", new LiteralOp(true));
            inputargs.put("cast", new LiteralOp(false));
            ParameterizedBuiltinOp pbop = HopRewriteUtils.createParameterizedBuiltinOp(trgt, inputargs, Types.ParamBuiltinOp.REXPAND);
            HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
            hi = pbop;
            LOG.debug((Object)("Applied simplifyOuterSeqExpand (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop simplifyBinaryComparisonChain(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinaryPPred(hi) && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(1), 0.0, 1.0) && HopRewriteUtils.isBinaryPPred(hi.getInput().get(0))) {
            BinaryOp bop = (BinaryOp)hi;
            BinaryOp bop2 = (BinaryOp)hi.getInput().get(0);
            boolean one = HopRewriteUtils.isLiteralOfValue(hi.getInput().get(1), 1.0);
            if (one && bop.getOp() == Types.OpOp2.EQUAL || !one && bop.getOp() == Types.OpOp2.NOTEQUAL) {
                HopRewriteUtils.replaceChildReference(parent, bop, bop2, pos);
                HopRewriteUtils.cleanupUnreferenced(bop);
                hi = bop2;
                LOG.debug((Object)("Applied simplifyBinaryComparisonChain1 (line " + hi.getBeginLine() + ")"));
            } else if (!one && bop.getOp() == Types.OpOp2.EQUAL) {
                Types.OpOp2 optr = bop2.getComplementPPredOperation();
                BinaryOp tmp = HopRewriteUtils.createBinary(bop2.getInput().get(0), bop2.getInput().get(1), optr, bop2.isOuter());
                HopRewriteUtils.replaceChildReference(parent, bop, tmp, pos);
                HopRewriteUtils.cleanupUnreferenced(bop, bop2);
                hi = tmp;
                LOG.debug((Object)("Applied simplifyBinaryComparisonChain0 (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop simplifyCumsumColOrFullAggregates(Hop hi) {
        if ((HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.SUM, Types.Direction.Col) || HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.SUM, Types.Direction.RowCol)) && HopRewriteUtils.isUnary(hi.getInput().get(0), Types.OpOp1.CUMSUM) && hi.getInput().get(0).getParent().size() == 1) {
            Hop cumsumX = hi.getInput().get(0);
            Hop X = cumsumX.getInput().get(0);
            BinaryOp mult = HopRewriteUtils.createBinary(X, (Hop)HopRewriteUtils.createSeqDataGenOp(X, false), Types.OpOp2.MULT);
            HopRewriteUtils.replaceChildReference(hi, cumsumX, mult);
            HopRewriteUtils.removeAllChildReferences(cumsumX);
            LOG.debug((Object)("Applied simplifyCumsumColOrFullAggregates (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop simplifyCumsumReverse(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isReorg(hi, Types.ReOrgOp.REV) && HopRewriteUtils.isUnary(hi.getInput().get(0), Types.OpOp1.CUMSUM) && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isReorg(hi.getInput().get(0).getInput().get(0), Types.ReOrgOp.REV) && hi.getInput().get(0).getInput().get(0).getParent().size() == 1) {
            Hop cumsumX = hi.getInput().get(0);
            Hop revX = cumsumX.getInput().get(0);
            Hop X = revX.getInput().get(0);
            BinaryOp plus = HopRewriteUtils.createBinary(X, (Hop)HopRewriteUtils.createAggUnaryOp(X, Types.AggOp.SUM, Types.Direction.Col), Types.OpOp2.PLUS);
            BinaryOp minus = HopRewriteUtils.createBinary((Hop)plus, (Hop)HopRewriteUtils.createUnary(X, Types.OpOp1.CUMSUM), Types.OpOp2.MINUS);
            HopRewriteUtils.replaceChildReference(parent, hi, minus, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, cumsumX, revX);
            hi = minus;
            LOG.debug((Object)("Applied simplifyCumsumReverse (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop removeUnecessaryPPred(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            Hop datagen = null;
            if (left == right && bop.getOp() == Types.OpOp2.EQUAL || bop.getOp() == Types.OpOp2.GREATEREQUAL || bop.getOp() == Types.OpOp2.LESSEQUAL) {
                datagen = HopRewriteUtils.createDataGenOp(left, 1.0);
            }
            if (left == right && bop.getOp() == Types.OpOp2.NOTEQUAL || bop.getOp() == Types.OpOp2.GREATER || bop.getOp() == Types.OpOp2.LESS) {
                datagen = HopRewriteUtils.createDataGenOp(left, 0.0);
            }
            if (datagen != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, datagen, pos);
                hi = datagen;
            }
        }
        return hi;
    }

    private static void removeTWriteTReadPairs(ArrayList<Hop> roots) {
        Iterator<Hop> iter = roots.iterator();
        while (iter.hasNext()) {
            Hop root = iter.next();
            if (!HopRewriteUtils.isData(root, Types.OpOpData.TRANSIENTWRITE) || !HopRewriteUtils.isData(root.getInput(0), Types.OpOpData.TRANSIENTREAD) || !root.getName().equals(root.getInput(0).getName()) || root.getInput(0).requiresCheckpoint()) continue;
            iter.remove();
        }
    }
}

