/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.plan;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.SingleIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SchemeFactory;
import org.apache.sysds.runtime.compress.plan.IPlanEncode;
import org.apache.sysds.runtime.compress.plan.NaivePlanEncode;

public class CompressionPlanFactory {
    public static IPlanEncode singleCols(int nCol, AColGroup.CompressionType type, int k) {
        ICLAScheme[] schemes = new ICLAScheme[nCol];
        for (int i = 0; i < nCol; ++i) {
            schemes[i] = SchemeFactory.create(new SingleIndex(i), type);
        }
        return new NaivePlanEncode(schemes, k, false);
    }

    public static IPlanEncode twoCols(int nCol, AColGroup.CompressionType type, int k) {
        ICLAScheme[] schemes = new ICLAScheme[nCol / 2 + nCol % 2];
        for (int i = 0; i < nCol; i += 2) {
            schemes[i / 2] = i + 1 >= nCol ? SchemeFactory.create(new SingleIndex(i), type) : SchemeFactory.create(new TwoIndex(i, i + 1), type);
        }
        return new NaivePlanEncode(schemes, k, false);
    }

    public static IPlanEncode nCols(int nCol, int n, AColGroup.CompressionType type, int k) {
        ICLAScheme[] schemes = new ICLAScheme[nCol / n + (nCol % n != 0 ? 1 : 0)];
        for (int i = 0; i < nCol; i += n) {
            schemes[i / n] = i + n < nCol ? SchemeFactory.create(ColIndexFactory.create(i, i + n), type) : SchemeFactory.create(ColIndexFactory.create(i, nCol), type);
        }
        return new NaivePlanEncode(schemes, k, false);
    }

    public static IPlanEncode create(IColIndex[] columnGroups, AColGroup.CompressionType[] type, int k) {
        ICLAScheme[] schemes = new ICLAScheme[columnGroups.length];
        for (int i = 0; i < columnGroups.length; ++i) {
            schemes[i] = SchemeFactory.create(columnGroups[i], type[i]);
        }
        return new NaivePlanEncode(schemes, k, false);
    }
}

