/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import org.apache.sysds.runtime.data.DenseBlock;

public abstract class DenseBlockDRB
extends DenseBlock {
    private static final long serialVersionUID = 3581157975703708947L;

    protected DenseBlockDRB(int[] dims) {
        super(dims);
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this.allocateBlock(0, len);
            if (v != 0.0) {
                this.fillBlock(0, 0, len, v);
            }
        } else {
            this.fillBlock(0, 0, len, v);
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public int numBlocks() {
        return 1;
    }

    @Override
    public int blockSize() {
        return this._rlen;
    }

    @Override
    public int blockSize(int bix) {
        return this._rlen;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return true;
    }

    @Override
    public int size(int bix) {
        return (int)this.size();
    }

    @Override
    public int pos(int r) {
        return r * this._odims[0];
    }

    @Override
    public int pos(int r, int c) {
        return r * this._odims[0] + c;
    }

    @Override
    public int pos(int[] ix) {
        int pos = ix[ix.length - 1];
        for (int i = 0; i < ix.length - 1; ++i) {
            pos += ix[i] * this._odims[i];
        }
        return pos;
    }

    @Override
    public long countNonZeros() {
        return this.computeNnz(0, 0, this._rlen * this._odims[0]);
    }

    @Override
    public int countNonZeros(int r) {
        return (int)this.computeNnz(0, r * this._odims[0], this._odims[0]);
    }

    @Override
    public long countNonZeros(int rl, int ru, int ol, int ou) {
        long nnz = 0L;
        if (ol == 0 && ou == this._odims[0]) {
            nnz += this.computeNnz(0, rl * this._odims[0], (ru - rl) * this._odims[0]);
        } else {
            int i = rl;
            int ix = rl * this._odims[0];
            while (i < ru) {
                nnz += this.computeNnz(0, ix + ol, ou - ol);
                ++i;
                ix += this._odims[0];
            }
        }
        return nnz;
    }

    @Override
    public DenseBlock set(int rl, int ru, int cl, int cu, double v) {
        if (cl == 0 && cu == this._odims[0]) {
            this.fillBlock(0, rl * this._odims[0], ru * this._odims[0], v);
        } else {
            int i = rl;
            int ix = rl * this._odims[0];
            while (i < ru) {
                this.fillBlock(0, ix + cl, ix + cu, v);
                ++i;
                ix += this._odims[0];
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(double v) {
        this.fillBlock(0, 0, this._rlen * this._odims[0], v);
        return this;
    }
}

