/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.CastSPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class CastFEDInstruction
extends UnaryFEDInstruction {
    private CastFEDInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.Cast, op, in, out, opcode, istr);
    }

    public static CastFEDInstruction parseInstruction(CastSPInstruction inst, ExecutionContext ec) {
        if ((inst.getOpcode().equalsIgnoreCase(Types.OpOp1.CAST_AS_FRAME.toString()) || inst.getOpcode().equalsIgnoreCase(Types.OpOp1.CAST_AS_MATRIX.toString())) && inst.input1.isMatrix() && ec.getCacheableData(inst.input1).isFederatedExcept(FTypes.FType.BROADCAST)) {
            return CastFEDInstruction.parseInstruction(inst);
        }
        return null;
    }

    private static CastFEDInstruction parseInstruction(CastSPInstruction spInstruction) {
        return new CastFEDInstruction(spInstruction.getOperator(), spInstruction.input1, spInstruction.output, spInstruction.getOpcode(), spInstruction.getInstructionString());
    }

    public static CastFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CastFEDInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.getOpcode().equals(Types.OpOp1.CAST_AS_MATRIX.toString())) {
            this.processCastAsMatrixVariableInstruction(ec);
        } else if (this.getOpcode().equals(Types.OpOp1.CAST_AS_FRAME.toString())) {
            this.processCastAsFrameVariableInstruction(ec);
        } else {
            throw new DMLRuntimeException("Unsupported Opcode for federated Variable Instruction : " + this.getOpcode());
        }
    }

    private void processCastAsMatrixVariableInstruction(ExecutionContext ec) {
        FrameObject mo1 = ec.getFrameObject(this.input1);
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated Cast: Federated input expected, but invoked w/ " + mo1.isFederated());
        }
        long id = FederationUtils.getNextFedDataID();
        FederatedRequest fr1 = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(-1L, -1L), Types.DataType.MATRIX});
        FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{mo1.getFedMapping().getID()}, Types.ExecType.SPARK, false);
        mo1.getFedMapping().execute(this.getTID(), true, fr1, fr2);
        MatrixObject out = ec.getMatrixObject(this.output);
        FederationMap outMap = mo1.getFedMapping().copyWithNewID(fr1.getID());
        ArrayList<Pair> newMap = new ArrayList<Pair>();
        for (Pair<FederatedRange, FederatedData> pair : outMap.getMap()) {
            FederatedData om = (FederatedData)pair.getValue();
            FederatedData nf = new FederatedData(Types.DataType.MATRIX, om.getAddress(), om.getFilepath(), om.getVarID());
            newMap.add(Pair.of((Object)((FederatedRange)pair.getKey()), (Object)nf));
        }
        out.setFedMapping(outMap);
    }

    private void processCastAsFrameVariableInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated Reorg: Federated input expected, but invoked w/ " + mo1.isFederated());
        }
        long id = FederationUtils.getNextFedDataID();
        FederatedRequest fr1 = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(-1L, -1L), Types.DataType.FRAME});
        FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{mo1.getFedMapping().getID()}, Types.ExecType.SPARK, false);
        mo1.getFedMapping().execute(this.getTID(), true, fr1, fr2);
        FrameObject out = ec.getFrameObject(this.output);
        out.getDataCharacteristics().set(mo1.getNumRows(), mo1.getNumColumns(), mo1.getBlocksize(), mo1.getNnz());
        FederationMap outMap = mo1.getFedMapping().copyWithNewID(fr2.getID());
        ArrayList<Pair> newMap = new ArrayList<Pair>();
        for (Map.Entry entry : outMap.getMap()) {
            FederatedData om = (FederatedData)entry.getValue();
            FederatedData nf = new FederatedData(Types.DataType.FRAME, om.getAddress(), om.getFilepath(), om.getVarID());
            newMap.add(Pair.of((Object)((FederatedRange)entry.getKey()), (Object)nf));
        }
        Types.ValueType[] schema = new Types.ValueType[(int)mo1.getDataCharacteristics().getCols()];
        Arrays.fill((Object[])schema, (Object)Types.ValueType.FP64);
        out.setSchema(schema);
        out.setFedMapping(outMap);
    }
}

