/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Map;
import jcuda.Pointer;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;

public class LineageCacheEntry {
    protected final LineageItem _key;
    protected final Types.DataType _dt;
    protected MatrixBlock _MBval;
    protected ScalarObject _SOval;
    protected byte[] _serialBytes;
    protected long _computeTime;
    protected long _timestamp = 0L;
    protected LineageCacheConfig.LineageCacheStatus _status;
    protected LineageCacheEntry _nextEntry;
    protected LineageItem _origItem;
    private String _outfile = null;
    protected double score;
    protected GPUPointer _gpuPointer;
    protected RDDObject _rddObject;

    public LineageCacheEntry(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        this._key = key;
        this._dt = dt;
        this._MBval = Mval;
        this._SOval = Sval;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this._nextEntry = null;
        this._origItem = null;
        this._outfile = null;
        this._gpuPointer = null;
    }

    protected synchronized void setCacheStatus(LineageCacheConfig.LineageCacheStatus st) {
        this._status = st;
    }

    public synchronized MatrixBlock getMBValue() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._MBval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized ScalarObject getSOValue() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._SOval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized RDDObject getRDDObject() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._rddObject;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized byte[] getSerializedBytes() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._serialBytes;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized Pointer getGPUPointer() {
        try {
            while (this._status == LineageCacheConfig.LineageCacheStatus.EMPTY) {
                this.wait();
            }
            return this._gpuPointer.getPointer();
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized LineageCacheConfig.LineageCacheStatus getCacheStatus() {
        return this._status;
    }

    protected synchronized void removeAndNotify() {
        if (this._status != LineageCacheConfig.LineageCacheStatus.EMPTY) {
            return;
        }
        this._status = LineageCacheConfig.LineageCacheStatus.NOTCACHED;
        this.notifyAll();
    }

    public synchronized long getSize() {
        long size = 0L;
        if (this._MBval != null) {
            size += this._MBval.getInMemorySize();
        }
        if (this._SOval != null) {
            size += (long)this._SOval.getSize();
        }
        if (this._gpuPointer != null) {
            size += this._gpuPointer.getPointerSize();
        }
        if (this._rddObject != null) {
            size += SparkExecutionContext.getMemCachedRDDSize(this._rddObject.getRDD().id());
        }
        return size;
    }

    public boolean isNullVal() {
        return this._MBval == null && this._SOval == null && this._gpuPointer == null && this._serialBytes == null && this._rddObject == null;
    }

    public boolean isMatrixValue() {
        return this._dt.isMatrix() && this._rddObject == null && this._gpuPointer == null;
    }

    public boolean isScalarValue() {
        return this._dt.isScalar() && this._rddObject == null && this._gpuPointer == null;
    }

    public boolean isLocalObject() {
        return this.isMatrixValue() || this.isScalarValue();
    }

    public boolean isRDDPersist() {
        return this._rddObject != null;
    }

    public boolean isGPUObject() {
        return this._gpuPointer != null;
    }

    public synchronized boolean isDensePointer() {
        if (!this.isGPUObject()) {
            return false;
        }
        return this._gpuPointer.isDensepointer();
    }

    public boolean isSerializedBytes() {
        return this._dt.isUnknown() && this._key.getOpcode().equals("serialize");
    }

    public synchronized void setValue(MatrixBlock val, long computetime) {
        this._MBval = val;
        this._gpuPointer = null;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
        if (DMLScript.STATISTICS && val != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void setValue(MatrixBlock val) {
        this.setValue(val, this._computeTime);
    }

    public synchronized void setValue(ScalarObject val, long computetime) {
        this._SOval = val;
        this._gpuPointer = null;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
        if (DMLScript.STATISTICS && val != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void setGPUValue(Pointer ptr, long size, MetaData md, long computetime) {
        this._gpuPointer = new GPUPointer(ptr, size, md);
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.GPUCACHED;
        this.notifyAll();
        if (DMLScript.STATISTICS && ptr != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void setRDDValue(RDDObject rdd, long computetime) {
        this._rddObject = rdd;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.TOPERSISTRDD;
        this.notifyAll();
        if (DMLScript.STATISTICS && rdd != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void setRDDValue(RDDObject rdd) {
        this._rddObject = rdd;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.TOPERSISTRDD;
        this.notifyAll();
        if (DMLScript.STATISTICS && rdd != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void setValue(byte[] serialBytes, long computetime) {
        this._serialBytes = serialBytes;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
        if (DMLScript.STATISTICS && serialBytes != null) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    public synchronized void copyValueFrom(LineageCacheEntry src, long computetime) {
        this._MBval = src._MBval;
        this._SOval = src._SOval;
        this._gpuPointer = src._gpuPointer;
        this._rddObject = src._rddObject;
        this._computeTime = src._computeTime;
        this._status = src._status;
        this.notifyAll();
    }

    public synchronized DataCharacteristics getDataCharacteristics() {
        return this._gpuPointer.getDataCharacteristics();
    }

    protected synchronized void setNullValues() {
        this._MBval = null;
        this._SOval = null;
        this._serialBytes = null;
        this._status = LineageCacheConfig.LineageCacheStatus.EMPTY;
    }

    protected synchronized void setOutfile(String outfile) {
        this._outfile = outfile;
    }

    protected synchronized String getOutfile() {
        return this._outfile;
    }

    protected synchronized void setTimestamp() {
        if (this._timestamp != 0L) {
            return;
        }
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        this.recomputeScore();
    }

    protected synchronized void updateTimestamp() {
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        this.recomputeScore();
    }

    protected synchronized void computeScore(Map<LineageItem, Integer> removeList) {
        this.setTimestamp();
        if (removeList.containsKey(this._key) && LineageCacheConfig.isCostNsize()) {
            double w1 = LineageCacheConfig.WEIGHTS[0];
            int missCount = 1 + removeList.get(this._key);
            if (this.isLocalObject()) {
                this.score += w1 * ((double)this._computeTime / (double)this.getSize()) * (double)missCount;
            }
        }
    }

    protected synchronized void initiateScoreSpark(Map<LineageItem, Integer> removeList, long estimatedSize) {
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        double w1 = LineageCacheConfig.WEIGHTS[0];
        double w2 = LineageCacheConfig.WEIGHTS[1];
        double w3 = LineageCacheConfig.WEIGHTS[2];
        int computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
        int refCount = Math.max(this._rddObject.getMaxReferenceCount(), 1);
        this.score = w1 * ((double)computeGroup * (double)refCount / (double)estimatedSize) + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight());
        if (removeList.containsKey(this._key) && LineageCacheConfig.isCostNsize()) {
            int missCount = 1 + removeList.get(this._key);
            this.score += w1 * ((double)computeGroup * (double)refCount / (double)estimatedSize) * (double)missCount;
        }
    }

    protected synchronized void initiateScoreGPU(Map<LineageItem, Integer> removeList) {
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        double w1 = 1.0;
        double w2 = 1.0;
        double w3 = 1.0;
        int computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
        this.score = w1 * (double)computeGroup + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight());
        if (removeList.containsKey(this._key) && w2 != 1.0) {
            int missCount = 1 + removeList.get(this._key);
            this.score += (w1 * (double)computeGroup + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight())) * (double)missCount;
        }
    }

    protected synchronized void updateScore(boolean add) {
        int computeGroup;
        int sign;
        double w1 = LineageCacheConfig.WEIGHTS[0];
        long size = this.getSize();
        int n = sign = add ? 1 : -1;
        if (this.isLocalObject()) {
            this.score += (double)sign * w1 * ((double)this._computeTime / (double)size);
        }
        if (this.isRDDPersist() && size != 0L) {
            computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
            this.score += (double)sign * w1 * ((double)computeGroup / (double)size);
        }
        if (this.isGPUObject()) {
            computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
            this.score += (double)sign * ((double)((long)computeGroup + this.getTimestamp()) + 1.0 / (double)this.getDagHeight());
        }
    }

    protected synchronized long getTimestamp() {
        return this._timestamp;
    }

    protected synchronized long getDagHeight() {
        return this._key.getHeight();
    }

    protected synchronized double getCostNsize() {
        return (double)this._computeTime / (double)this.getSize();
    }

    private void recomputeScore() {
        int computeGroup;
        double w1 = LineageCacheConfig.WEIGHTS[0];
        double w2 = LineageCacheConfig.WEIGHTS[1];
        double w3 = LineageCacheConfig.WEIGHTS[2];
        long size = this.getSize();
        if (this.isLocalObject()) {
            this.score = w1 * ((double)this._computeTime / (double)size) + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight());
        }
        if (this.isRDDPersist() && size != 0L) {
            computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
            int refCount = Math.max(this._rddObject.getMaxReferenceCount(), 1);
            this.score = w1 * ((double)computeGroup * (double)refCount / (double)size) + w2 * (double)this.getTimestamp() + w3 * (1.0 / (double)this.getDagHeight());
        }
        if (this.isGPUObject()) {
            computeGroup = LineageCacheConfig.getComputeGroup(this._key.getOpcode());
            this.score = (double)((long)computeGroup + this.getTimestamp()) + 1.0 / (double)this.getDagHeight();
        }
    }

    static class GPUPointer {
        private Pointer _pointer;
        private long _allocatedSize;
        private MetaData _metadata;

        public GPUPointer(Pointer pointer, long size, MetaData metadata) {
            this._pointer = pointer;
            this._allocatedSize = size;
            this._metadata = metadata;
        }

        protected long getPointerSize() {
            return this._allocatedSize;
        }

        protected Pointer getPointer() {
            return this._pointer;
        }

        protected DataCharacteristics getDataCharacteristics() {
            return this._metadata.getDataCharacteristics();
        }

        protected boolean isDensepointer() {
            return true;
        }
    }
}

