/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.And;
import org.apache.sysds.runtime.functionobjects.BitwAnd;
import org.apache.sysds.runtime.functionobjects.BitwOr;
import org.apache.sysds.runtime.functionobjects.BitwShiftL;
import org.apache.sysds.runtime.functionobjects.BitwShiftR;
import org.apache.sysds.runtime.functionobjects.BitwXor;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Equals;
import org.apache.sysds.runtime.functionobjects.GreaterThan;
import org.apache.sysds.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysds.runtime.functionobjects.IntegerDivide;
import org.apache.sysds.runtime.functionobjects.LessThan;
import org.apache.sysds.runtime.functionobjects.LessThanEquals;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Minus1Multiply;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.MinusNz;
import org.apache.sysds.runtime.functionobjects.Modulus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.NotEquals;
import org.apache.sysds.runtime.functionobjects.Or;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.functionobjects.Power;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.functionobjects.Xor;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;

public class BinaryOperator
extends MultiThreadedOperator {
    private static final long serialVersionUID = -2547950181558989209L;
    public final ValueFunction fn;
    public final boolean commutative;

    public BinaryOperator(ValueFunction p) {
        this(p, 1);
    }

    public BinaryOperator(ValueFunction p, int k) {
        super(p instanceof Plus || p instanceof Multiply || p instanceof Minus || p instanceof PlusMultiply || p instanceof MinusMultiply || p instanceof And || p instanceof Or || p instanceof Xor || p instanceof BitwAnd || p instanceof BitwOr || p instanceof BitwXor || p instanceof BitwShiftL || p instanceof BitwShiftR);
        this.fn = p;
        this.commutative = p instanceof Plus || p instanceof Multiply || p instanceof And || p instanceof Or || p instanceof Xor || p instanceof Minus1Multiply;
        this._numThreads = k;
    }

    public Types.OpOp2 getBinaryOperatorOpOp2() {
        if (this.fn instanceof Plus) {
            return Types.OpOp2.PLUS;
        }
        if (this.fn instanceof Minus) {
            return Types.OpOp2.MINUS;
        }
        if (this.fn instanceof Multiply) {
            return Types.OpOp2.MULT;
        }
        if (this.fn instanceof Divide) {
            return Types.OpOp2.DIV;
        }
        if (this.fn instanceof Modulus) {
            return Types.OpOp2.MODULUS;
        }
        if (this.fn instanceof IntegerDivide) {
            return Types.OpOp2.INTDIV;
        }
        if (this.fn instanceof LessThan) {
            return Types.OpOp2.LESS;
        }
        if (this.fn instanceof LessThanEquals) {
            return Types.OpOp2.LESSEQUAL;
        }
        if (this.fn instanceof GreaterThan) {
            return Types.OpOp2.GREATER;
        }
        if (this.fn instanceof GreaterThanEquals) {
            return Types.OpOp2.GREATEREQUAL;
        }
        if (this.fn instanceof Equals) {
            return Types.OpOp2.EQUAL;
        }
        if (this.fn instanceof NotEquals) {
            return Types.OpOp2.NOTEQUAL;
        }
        if (this.fn instanceof And) {
            return Types.OpOp2.AND;
        }
        if (this.fn instanceof Or) {
            return Types.OpOp2.OR;
        }
        if (this.fn instanceof Xor) {
            return Types.OpOp2.XOR;
        }
        if (this.fn instanceof BitwAnd) {
            return Types.OpOp2.BITWAND;
        }
        if (this.fn instanceof BitwOr) {
            return Types.OpOp2.BITWOR;
        }
        if (this.fn instanceof BitwXor) {
            return Types.OpOp2.BITWXOR;
        }
        if (this.fn instanceof BitwShiftL) {
            return Types.OpOp2.BITWSHIFTL;
        }
        if (this.fn instanceof BitwShiftR) {
            return Types.OpOp2.BITWSHIFTR;
        }
        if (this.fn instanceof Power) {
            return Types.OpOp2.POW;
        }
        if (this.fn instanceof MinusNz) {
            return Types.OpOp2.MINUS_NZ;
        }
        if (this.fn instanceof Builtin) {
            Builtin.BuiltinCode bfc = ((Builtin)this.fn).getBuiltinCode();
            if (bfc == Builtin.BuiltinCode.MIN) {
                return Types.OpOp2.MIN;
            }
            if (bfc == Builtin.BuiltinCode.MAX) {
                return Types.OpOp2.MAX;
            }
            if (bfc == Builtin.BuiltinCode.LOG) {
                return Types.OpOp2.LOG;
            }
            if (bfc == Builtin.BuiltinCode.LOG_NZ) {
                return Types.OpOp2.LOG_NZ;
            }
        }
        return null;
    }

    public boolean isCommutative() {
        return this.commutative;
    }

    public boolean isRowSafeLeft(double[] row) {
        for (double v : row) {
            if (0.0 == this.fn.execute(v, 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowSafeLeft(MatrixBlock row) {
        if (row.isEmpty()) {
            return 0.0 == this.fn.execute(0.0, 0.0);
        }
        if (row.isInSparseFormat()) {
            if (0.0 != this.fn.execute(0.0, 0.0)) {
                return false;
            }
            SparseBlock sb = row.getSparseBlock();
            if (sb.isEmpty(0)) {
                return true;
            }
            return this.isRowSafeLeft(sb.values(0));
        }
        return this.isRowSafeLeft(row.getDenseBlockValues());
    }

    public boolean isIntroducingZerosLeft(MatrixBlock row) {
        if (row.isEmpty()) {
            return this.introduceZeroLeft(0.0);
        }
        if (row.isInSparseFormat()) {
            if (this.introduceZeroLeft(0.0)) {
                return true;
            }
            SparseBlock sb = row.getSparseBlock();
            if (sb.isEmpty(0)) {
                return false;
            }
            return this.isIntroducingZerosLeft(sb.values(0));
        }
        return this.isIntroducingZerosLeft(row.getDenseBlockValues());
    }

    public boolean isIntroducingZerosLeft(double[] row) {
        for (double v : row) {
            if (!this.introduceZeroLeft(v)) continue;
            return true;
        }
        return false;
    }

    private boolean introduceZeroLeft(double v) {
        return 0.0 == this.fn.execute(v, 11.42) && 0.0 == this.fn.execute(v, -11.22);
    }

    public boolean isRowSafeRight(double[] row) {
        for (double v : row) {
            if (0.0 == this.fn.execute(0.0, v)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowSafeRight(MatrixBlock row) {
        if (row.isEmpty()) {
            return 0.0 == this.fn.execute(0.0, 0.0);
        }
        if (row.isInSparseFormat()) {
            if (0.0 != this.fn.execute(0.0, 0.0)) {
                return false;
            }
            SparseBlock sb = row.getSparseBlock();
            if (sb.isEmpty(0)) {
                return true;
            }
            return this.isRowSafeRight(sb.values(0));
        }
        return this.isRowSafeRight(row.getDenseBlockValues());
    }

    public boolean isIntroducingZerosRight(MatrixBlock row) {
        if (row.isEmpty()) {
            return this.introduceZeroRight(0.0);
        }
        if (row.isInSparseFormat()) {
            if (this.introduceZeroRight(0.0)) {
                return true;
            }
            SparseBlock sb = row.getSparseBlock();
            if (sb.isEmpty(0)) {
                return false;
            }
            return this.isIntroducingZerosRight(sb.values(0));
        }
        return this.isIntroducingZerosRight(row.getDenseBlockValues());
    }

    public boolean isIntroducingZerosRight(double[] row) {
        for (double v : row) {
            if (!this.introduceZeroRight(v)) continue;
            return true;
        }
        return false;
    }

    private boolean introduceZeroRight(double v) {
        return 0.0 == this.fn.execute(11.42, v) && 0.0 == this.fn.execute(-11.22, v);
    }

    public String toString() {
        return "BinaryOperator(" + this.fn.getClass().getSimpleName() + ")";
    }
}

