/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ACostEstimate
implements Serializable {
    private static final long serialVersionUID = -3241425555L;
    protected static final Log LOG = LogFactory.getLog((String)ACostEstimate.class.getName());

    protected ACostEstimate() {
    }

    public double getCost(Collection<AColGroup> cgs, int nRows) {
        double c = 0.0;
        for (AColGroup g : cgs) {
            c += this.getCost(g, nRows);
        }
        return c;
    }

    public final double getCost(CompressedSizeInfoColGroup g) {
        return g == null ? Double.POSITIVE_INFINITY : this.getCostSafe(g);
    }

    public double getCost(CompressedSizeInfo i) {
        double c = 0.0;
        for (CompressedSizeInfoColGroup g : i.getInfo()) {
            c += this.getCost(g);
        }
        return c;
    }

    public double getCost(CompressedMatrixBlock cmb) {
        int nRows = cmb.getNumRows();
        double c = 0.0;
        for (AColGroup g : cmb.getColGroups()) {
            c += this.getCost(g, nRows);
        }
        return c;
    }

    public abstract double getCost(MatrixBlock var1);

    public abstract double getCost(AColGroup var1, int var2);

    protected abstract double getCostSafe(CompressedSizeInfoColGroup var1);

    public abstract boolean shouldSparsify();

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

