/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MatrixBuiltinNaryCPInstruction
extends BuiltinNaryCPInstruction
implements LineageTraceable {
    protected MatrixBuiltinNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand[] inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        List<MatrixBlock> matrices = ec.getMatrixInputs(this.inputs, true);
        List<ScalarObject> scalars = ec.getScalarInputs(this.inputs);
        List<FrameBlock> frames = ec.getFrameInputs(this.inputs);
        CacheBlock outBlock = null;
        if (Opcodes.CBIND.toString().equals(this.getOpcode()) || Opcodes.RBIND.toString().equals(this.getOpcode())) {
            boolean cbind = Opcodes.CBIND.toString().equals(this.getOpcode());
            if (frames.size() == 0) {
                outBlock = matrices.size() == 0 ? new MatrixBlock(0, 0, 0L) : matrices.get(0).append(matrices.subList(1, matrices.size()).toArray(new MatrixBlock[0]), new MatrixBlock(), cbind);
            } else {
                outBlock = frames.get(0);
                for (int i = 1; i < frames.size(); ++i) {
                    outBlock = ((FrameBlock)outBlock).append(frames.get(i), cbind);
                }
            }
        } else if (ArrayUtils.contains((Object[])new String[]{Opcodes.NMIN.toString(), Opcodes.NMAX.toString(), Opcodes.NP.toString(), Opcodes.NM.toString()}, (Object)this.getOpcode())) {
            outBlock = MatrixBlock.naryOperations(this._optr, matrices.toArray(new MatrixBlock[0]), scalars.toArray(new ScalarObject[0]), new MatrixBlock());
        } else {
            throw new DMLRuntimeException("Unknown opcode: " + this.getOpcode());
        }
        ec.releaseMatrixInputs(this.inputs, true);
        ec.releaseFrameInputs(this.inputs);
        if (this.output.getDataType().isMatrix()) {
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)outBlock);
        } else if (this.output.getDataType().isFrame()) {
            ec.setFrameOutput(this.output.getName(), (FrameBlock)outBlock);
        } else {
            ec.setVariable(this.output.getName(), ScalarObjectFactory.createScalarObject(this.output.getValueType(), ((MatrixBlock)outBlock).get(0, 0)));
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.inputs)));
    }
}

