/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.utils.Statistics;

public final class MatrixIndexingCPInstruction
extends IndexingCPInstruction {
    public MatrixIndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected MatrixIndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        boolean inRange;
        String opcode = this.getOpcode();
        IndexRange ix = this.getIndexRange(ec);
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        boolean bl = inRange = ix.rowStart < mo.getNumRows() && ix.colStart < mo.getNumColumns();
        if (opcode.equalsIgnoreCase(Opcodes.RIGHT_INDEX.toString())) {
            if (this.output.isScalar() && inRange) {
                MatrixBlock matBlock = (MatrixBlock)mo.acquireReadAndRelease();
                ec.setScalarOutput(this.output.getName(), new DoubleObject(matBlock.get((int)ix.rowStart, (int)ix.colStart)));
            } else {
                MatrixBlock resultBlock = null;
                if (mo.isPartitioned()) {
                    resultBlock = mo.readMatrixPartition(ix.add(1));
                } else if (ix.isScalar() && inRange) {
                    MatrixBlock matBlock = (MatrixBlock)mo.acquireReadAndRelease();
                    resultBlock = new MatrixBlock(matBlock.get((int)ix.rowStart, (int)ix.colStart));
                } else {
                    MatrixBlock matBlock = (MatrixBlock)mo.acquireRead();
                    resultBlock = matBlock.slice((int)ix.rowStart, (int)ix.rowEnd, (int)ix.colStart, (int)ix.colEnd, false, new MatrixBlock());
                    ec.releaseMatrixInput(this.input1.getName());
                    if (this.checkGuardedRepresentationChange(matBlock, resultBlock)) {
                        resultBlock.examSparsity();
                    }
                }
                ec.setMatrixOutput(this.output.getName(), resultBlock);
            }
        } else if (opcode.equalsIgnoreCase(Opcodes.LEFT_INDEX.toString())) {
            MatrixObject.UpdateType updateType = mo.getUpdateType();
            if (DMLScript.STATISTICS) {
                if (updateType.isInPlace()) {
                    Statistics.incrementTotalLixUIP();
                }
                Statistics.incrementTotalLix();
            }
            MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
            MatrixBlock resultBlock = null;
            if (this.input2.getDataType() == Types.DataType.MATRIX) {
                MatrixBlock rhsMatBlock = ec.getMatrixInput(this.input2.getName());
                resultBlock = matBlock.leftIndexingOperations(rhsMatBlock, ix, new MatrixBlock(), updateType);
                ec.releaseMatrixInput(this.input2.getName());
            } else {
                if (!ix.isScalar()) {
                    throw new DMLRuntimeException("Invalid index range of scalar leftindexing: " + ix.toString() + ".");
                }
                ScalarObject scalar = ec.getScalarInput(this.input2.getName(), Types.ValueType.FP64, this.input2.isLiteral());
                resultBlock = matBlock.leftIndexingOperations(scalar, (int)ix.rowStart, (int)ix.colStart, new MatrixBlock(), updateType);
            }
            ec.releaseMatrixInput(this.input1.getName());
            resultBlock.examSparsity();
            ec.setMatrixOutput(this.output.getName(), resultBlock, updateType);
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in MatrixIndexingCPInstruction.");
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.rowLower, this.rowUpper, this.colLower, this.colUpper)));
    }
}

