/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.internal.services.ExceptionAnalysisImpl;
import org.apache.tapestry5.ioc.internal.services.ExceptionInfoImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.ExceptionAnalysis;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionInfo;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;

public class ExceptionAnalyzerImpl
implements ExceptionAnalyzer {
    private final PropertyAccess propertyAccess;
    private final Set<String> throwableProperties;

    public ExceptionAnalyzerImpl(PropertyAccess propertyAccess) {
        this.propertyAccess = propertyAccess;
        this.throwableProperties = CollectionFactory.newSet((Collection)this.propertyAccess.getAdapter(Throwable.class).getPropertyNames());
    }

    @Override
    public ExceptionAnalysis analyze(Throwable rootException) {
        List list = CollectionFactory.newList();
        Throwable t = rootException;
        ExceptionInfo previousInfo = null;
        while (t != null) {
            ExceptionData data = this.extractData(t);
            ExceptionInfo info = data.exceptionInfo;
            if (this.addsValue(previousInfo, info)) {
                list.add(info);
                previousInfo = info;
            }
            t = data.cause;
        }
        return new ExceptionAnalysisImpl(list);
    }

    private boolean addsValue(ExceptionInfo previousInfo, ExceptionInfo info) {
        if (previousInfo == null) {
            return true;
        }
        if (!info.getStackTrace().isEmpty()) {
            return true;
        }
        if (!info.getClassName().equals(previousInfo.getClassName())) {
            return true;
        }
        if (!previousInfo.getMessage().contains(info.getMessage())) {
            return true;
        }
        for (String name : info.getPropertyNames()) {
            if (info.getProperty(name).equals(previousInfo.getProperty(name))) continue;
            return true;
        }
        return false;
    }

    private ExceptionData extractData(Throwable t) {
        Map properties = CollectionFactory.newMap();
        ClassPropertyAdapter adapter = this.propertyAccess.getAdapter((Object)t);
        Throwable cause = null;
        for (String name : adapter.getPropertyNames()) {
            Object value;
            PropertyAdapter pa = adapter.getPropertyAdapter(name);
            if (!pa.isRead()) continue;
            if (cause == null && Throwable.class.isAssignableFrom(pa.getType())) {
                Throwable nestedException = (Throwable)pa.get((Object)t);
                if (t == nestedException) continue;
                cause = nestedException;
                continue;
            }
            if (this.throwableProperties.contains(name) || (value = pa.get((Object)t)) == null) continue;
            properties.put(name, value);
        }
        List<StackTraceElement> stackTrace = Collections.emptyList();
        if (cause == null) {
            stackTrace = Arrays.asList(t.getStackTrace());
        }
        ExceptionInfoImpl info = new ExceptionInfoImpl(t, properties, stackTrace);
        return new ExceptionData(info, cause);
    }

    private static class ExceptionData {
        final ExceptionInfo exceptionInfo;
        final Throwable cause;

        public ExceptionData(ExceptionInfo exceptionInfo, Throwable cause) {
            this.exceptionInfo = exceptionInfo;
            this.cause = cause;
        }
    }
}

