/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.javascript;

import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.annotations.UsesOrderedConfiguration;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StackExtension;
import org.apache.tapestry5.services.javascript.StackExtensionType;
import org.apache.tapestry5.services.javascript.StylesheetLink;

@UsesOrderedConfiguration(value=StackExtension.class)
public class ExtensibleJavaScriptStack
implements JavaScriptStack {
    private final AssetSource assetSource;
    private final List<Asset> libraries;
    private final List<StylesheetLink> stylesheets;
    private final List<String> stacks;
    private final List<String> modules;
    private final String initialization;
    private final JavaScriptAggregationStrategy strategy;
    private final Mapper<StackExtension, String> extractValue = new Mapper<StackExtension, String>(){

        public String map(StackExtension element) {
            return element.value;
        }
    };
    private final Mapper<String, Asset> stringToAsset = new Mapper<String, Asset>(){

        public Asset map(String value) {
            return ExtensibleJavaScriptStack.this.assetSource.getExpandedAsset(value);
        }
    };
    private final Mapper<Asset, StylesheetLink> assetToStylesheetLink = new Mapper<Asset, StylesheetLink>(){

        public StylesheetLink map(Asset asset) {
            return new StylesheetLink(asset);
        }
    };
    private final Mapper<String, JavaScriptAggregationStrategy> stringToStrategy = new Mapper<String, JavaScriptAggregationStrategy>(){

        public JavaScriptAggregationStrategy map(String name) {
            return JavaScriptAggregationStrategy.valueOf(name);
        }
    };

    private final Predicate<StackExtension> by(final StackExtensionType type) {
        return new Predicate<StackExtension>(){

            public boolean accept(StackExtension element) {
                return element.type == type;
            }
        };
    }

    public ExtensibleJavaScriptStack(AssetSource assetSource, List<StackExtension> configuration) {
        this.assetSource = assetSource;
        Flow extensions = F.flow(configuration);
        this.libraries = ((Flow)extensions.filter(this.by(StackExtensionType.LIBRARY))).map(this.extractValue).map(this.stringToAsset).toList();
        this.stacks = ((Flow)extensions.filter(this.by(StackExtensionType.STACK))).map(this.extractValue).toList();
        this.modules = ((Flow)extensions.filter(this.by(StackExtensionType.MODULE))).map(this.extractValue).toList();
        this.stylesheets = ((Flow)extensions.filter(this.by(StackExtensionType.STYLESHEET))).map(this.extractValue).map(this.stringToAsset).map(this.assetToStylesheetLink).toList();
        List initializations = ((Flow)extensions.filter(this.by(StackExtensionType.INITIALIZATION))).map(this.extractValue).toList();
        this.initialization = initializations.isEmpty() ? null : InternalUtils.join((List)initializations, (String)"\n");
        this.strategy = this.toStrategy((Flow<StackExtension>)extensions);
    }

    private JavaScriptAggregationStrategy toStrategy(Flow<StackExtension> extensions) {
        List values = ((Flow)extensions.filter(this.by(StackExtensionType.AGGREGATION_STRATEGY))).map(this.extractValue).map(this.stringToStrategy).toList();
        switch (values.size()) {
            case 0: {
                return JavaScriptAggregationStrategy.COMBINE_AND_MINIMIZE;
            }
            case 1: {
                return (JavaScriptAggregationStrategy)((Object)values.get(0));
            }
        }
        throw new IllegalStateException(String.format("Could not handle %d contribution(s) of JavaScriptAggregation Strategy. There should be at most one.", values.size()));
    }

    @Override
    public List<String> getStacks() {
        return this.stacks;
    }

    @Override
    public List<Asset> getJavaScriptLibraries() {
        return this.libraries;
    }

    @Override
    public List<StylesheetLink> getStylesheets() {
        return this.stylesheets;
    }

    @Override
    public String getInitialization() {
        return this.initialization;
    }

    @Override
    public List<String> getModules() {
        return this.modules;
    }

    @Override
    public JavaScriptAggregationStrategy getJavaScriptAggregationStrategy() {
        return this.strategy;
    }
}

