/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.internal.plastic.InstructionBuilderState;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.NameCache;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.internal.plastic.SwitchBlockImpl;
import org.apache.tapestry5.internal.plastic.TryCatchBlockImpl;
import org.apache.tapestry5.internal.plastic.asm.Label;
import org.apache.tapestry5.internal.plastic.asm.MethodVisitor;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.LocalVariable;
import org.apache.tapestry5.plastic.LocalVariableCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.SwitchCallback;
import org.apache.tapestry5.plastic.TryCatchCallback;
import org.apache.tapestry5.plastic.WhenCallback;
import org.apache.tapestry5.plastic.WhileCallback;

public class InstructionBuilderImpl
extends Lockable
implements Opcodes,
InstructionBuilder {
    private static final int[] DUPE_OPCODES = new int[]{89, 90, 91};
    private static final Map<Condition, Integer> conditionToOpcode = new HashMap<Condition, Integer>();
    private static final Map<String, Integer> typeToSpecialComparisonOpcode;
    private static final Map<Object, Integer> constantOpcodes;
    protected final InstructionBuilderState state;
    protected final MethodVisitor v;
    protected final NameCache cache;

    InstructionBuilderImpl(MethodDescription description, MethodVisitor visitor, NameCache cache) {
        InstructionBuilderState state;
        this.state = state = new InstructionBuilderState(description, visitor, cache);
        this.v = state.visitor;
        this.cache = state.nameCache;
    }

    @Override
    public InstructionBuilder returnDefaultValue() {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(this.state.description.returnType);
        if (type == null) {
            this.v.visitInsn(1);
            this.v.visitInsn(176);
        } else {
            switch (type) {
                case VOID: {
                    break;
                }
                case LONG: {
                    this.v.visitInsn(9);
                    break;
                }
                case FLOAT: {
                    this.v.visitInsn(11);
                    break;
                }
                case DOUBLE: {
                    this.v.visitInsn(14);
                    break;
                }
                default: {
                    this.v.visitInsn(3);
                }
            }
            this.v.visitInsn(type.returnOpcode);
        }
        return this;
    }

    @Override
    public InstructionBuilder loadThis() {
        this.check();
        this.v.visitVarInsn(25, 0);
        return this;
    }

    @Override
    public InstructionBuilder loadNull() {
        this.check();
        this.v.visitInsn(1);
        return this;
    }

    @Override
    public InstructionBuilder loadArgument(int index) {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(this.state.description.argumentTypes[index]);
        int opcode = type == null ? 25 : type.loadOpcode;
        this.v.visitVarInsn(this.state.argumentLoadOpcode[index], this.state.argumentIndex[index]);
        return this;
    }

    @Override
    public InstructionBuilder loadArguments() {
        this.check();
        for (int i = 0; i < this.state.description.argumentTypes.length; ++i) {
            this.loadArgument(i);
        }
        return this;
    }

    @Override
    public InstructionBuilder invokeSpecial(String containingClassName, MethodDescription description) {
        this.check();
        this.doInvoke(183, containingClassName, description, false);
        return this;
    }

    @Override
    public InstructionBuilder invokeVirtual(PlasticMethod method) {
        this.check();
        assert (method != null);
        MethodDescription description = method.getDescription();
        return this.invokeVirtual(method.getPlasticClass().getClassName(), description.returnType, description.methodName, description.argumentTypes);
    }

    @Override
    public InstructionBuilder invokeVirtual(String className, String returnType, String methodName, String ... argumentTypes) {
        this.check();
        this.doInvoke(182, className, returnType, methodName, false, argumentTypes);
        return this;
    }

    @Override
    public InstructionBuilder invokeInterface(String interfaceName, String returnType, String methodName, String ... argumentTypes) {
        this.check();
        this.doInvoke(185, interfaceName, returnType, methodName, true, argumentTypes);
        return this;
    }

    private void doInvoke(int opcode, String className, String returnType, String methodName, boolean isInterface, String ... argumentTypes) {
        this.v.visitMethodInsn(opcode, this.cache.toInternalName(className), methodName, this.cache.toMethodDescriptor(returnType, argumentTypes), isInterface);
    }

    @Override
    public InstructionBuilder invokeStatic(Class clazz, Class returnType, String methodName, Class ... argumentTypes) {
        this.doInvoke(184, clazz, returnType, methodName, false, argumentTypes);
        return this;
    }

    private void doInvoke(int opcode, Class clazz, Class returnType, String methodName, boolean isInterface, Class ... argumentTypes) {
        this.doInvoke(opcode, clazz.getName(), this.cache.toTypeName(returnType), methodName, isInterface, PlasticUtils.toTypeNames(argumentTypes));
    }

    @Override
    public InstructionBuilder invoke(Method method) {
        this.check();
        return this.invoke(method.getDeclaringClass(), method.getReturnType(), method.getName(), method.getParameterTypes());
    }

    @Override
    public InstructionBuilder invoke(Class clazz, Class returnType, String methodName, Class ... argumentTypes) {
        this.check();
        this.doInvoke(clazz.isInterface() ? 185 : 182, clazz, returnType, methodName, clazz.isInterface(), argumentTypes);
        return this;
    }

    private void doInvoke(int opcode, String containingClassName, MethodDescription description, boolean isInterface) {
        this.v.visitMethodInsn(opcode, this.cache.toInternalName(containingClassName), description.methodName, this.cache.toDesc(description), isInterface);
    }

    @Override
    public InstructionBuilder returnResult() {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(this.state.description.returnType);
        int opcode = type == null ? 176 : type.returnOpcode;
        this.v.visitInsn(opcode);
        return this;
    }

    @Override
    public InstructionBuilder boxPrimitive(String typeName) {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(typeName);
        if (type != null && type != PrimitiveType.VOID) {
            this.v.visitMethodInsn(184, type.wrapperInternalName, "valueOf", type.valueOfMethodDescriptor, false);
        }
        return this;
    }

    @Override
    public InstructionBuilder unboxPrimitive(String typeName) {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(typeName);
        if (type != null) {
            this.doUnbox(type);
        }
        return this;
    }

    private void doUnbox(PrimitiveType type) {
        this.v.visitMethodInsn(182, type.wrapperInternalName, type.toValueMethodName, type.toValueMethodDescriptor, false);
    }

    @Override
    public InstructionBuilder getField(String className, String fieldName, String typeName) {
        this.check();
        this.v.visitFieldInsn(180, this.cache.toInternalName(className), fieldName, this.cache.toDesc(typeName));
        return this;
    }

    @Override
    public InstructionBuilder getStaticField(String className, String fieldName, String typeName) {
        this.check();
        this.v.visitFieldInsn(178, this.cache.toInternalName(className), fieldName, this.cache.toDesc(typeName));
        return this;
    }

    @Override
    public InstructionBuilder getStaticField(String className, String fieldName, Class fieldType) {
        this.check();
        return this.getStaticField(className, fieldName, this.cache.toTypeName(fieldType));
    }

    @Override
    public InstructionBuilder putStaticField(String className, String fieldName, Class fieldType) {
        this.check();
        return this.putStaticField(className, fieldName, this.cache.toTypeName(fieldType));
    }

    @Override
    public InstructionBuilder putStaticField(String className, String fieldName, String typeName) {
        this.check();
        this.v.visitFieldInsn(179, this.cache.toInternalName(className), fieldName, this.cache.toDesc(typeName));
        return this;
    }

    @Override
    public InstructionBuilder getField(PlasticField field) {
        this.check();
        return this.getField(field.getPlasticClass().getClassName(), field.getName(), field.getTypeName());
    }

    @Override
    public InstructionBuilder putField(String className, String fieldName, String typeName) {
        this.check();
        this.v.visitFieldInsn(181, this.cache.toInternalName(className), fieldName, this.cache.toDesc(typeName));
        return this;
    }

    @Override
    public InstructionBuilder putField(String className, String fieldName, Class fieldType) {
        this.check();
        return this.putField(className, fieldName, this.cache.toTypeName(fieldType));
    }

    @Override
    public InstructionBuilder getField(String className, String fieldName, Class fieldType) {
        this.check();
        return this.getField(className, fieldName, this.cache.toTypeName(fieldType));
    }

    @Override
    public InstructionBuilder loadArrayElement(int index, String elementType) {
        this.check();
        this.loadConstant(index);
        PrimitiveType type = PrimitiveType.getByName(elementType);
        if (type != null) {
            throw new RuntimeException("Access to non-object arrays is not yet supported.");
        }
        this.v.visitInsn(50);
        return this;
    }

    @Override
    public InstructionBuilder loadArrayElement() {
        this.check();
        this.v.visitInsn(50);
        return this;
    }

    @Override
    public InstructionBuilder checkcast(String className) {
        this.check();
        String internalName = className.contains("[") ? this.cache.toDesc(className) : this.cache.toInternalName(className);
        this.v.visitTypeInsn(192, internalName);
        return this;
    }

    @Override
    public InstructionBuilder checkcast(Class clazz) {
        this.check();
        return this.checkcast(this.cache.toTypeName(clazz));
    }

    @Override
    public InstructionBuilder startTryCatch(TryCatchCallback callback) {
        this.check();
        new TryCatchBlockImpl(this, this.state).doCallback(callback);
        return this;
    }

    @Override
    public InstructionBuilder newInstance(String className) {
        this.check();
        this.v.visitTypeInsn(187, this.cache.toInternalName(className));
        return this;
    }

    @Override
    public InstructionBuilder newInstance(Class clazz) {
        this.check();
        return this.newInstance(clazz.getName());
    }

    @Override
    public InstructionBuilder invokeConstructor(String className, String ... argumentTypes) {
        this.check();
        this.doInvoke(183, className, "void", "<init>", false, argumentTypes);
        return this;
    }

    @Override
    public InstructionBuilder invokeConstructor(Class clazz, Class ... argumentTypes) {
        this.check();
        return this.invokeConstructor(clazz.getName(), PlasticUtils.toTypeNames(argumentTypes));
    }

    @Override
    public InstructionBuilder dupe(int depth) {
        this.check();
        if (depth < 0 || depth >= DUPE_OPCODES.length) {
            throw new IllegalArgumentException(String.format("Dupe depth %d is invalid; values from 0 to %d are allowed.", depth, DUPE_OPCODES.length - 1));
        }
        this.v.visitInsn(DUPE_OPCODES[depth]);
        return this;
    }

    @Override
    public InstructionBuilder dupe() {
        this.check();
        this.v.visitInsn(89);
        return this;
    }

    @Override
    public InstructionBuilder pop() {
        this.check();
        this.v.visitInsn(87);
        return this;
    }

    @Override
    public InstructionBuilder swap() {
        this.check();
        this.v.visitInsn(95);
        return this;
    }

    @Override
    public InstructionBuilder loadConstant(Object constant) {
        this.check();
        Integer opcode = constantOpcodes.get(constant);
        if (opcode != null) {
            this.v.visitInsn(opcode);
        } else {
            this.v.visitLdcInsn(constant);
        }
        return this;
    }

    @Override
    public InstructionBuilder loadTypeConstant(String typeName) {
        this.check();
        Type type = Type.getType(this.cache.toDesc(typeName));
        this.v.visitLdcInsn(type);
        return this;
    }

    @Override
    public InstructionBuilder loadTypeConstant(Class clazz) {
        this.check();
        Type type = Type.getType(clazz);
        this.v.visitLdcInsn(type);
        return this;
    }

    @Override
    public InstructionBuilder castOrUnbox(String typeName) {
        this.check();
        PrimitiveType type = PrimitiveType.getByName(typeName);
        if (type == null) {
            return this.checkcast(typeName);
        }
        this.v.visitTypeInsn(192, type.wrapperInternalName);
        this.doUnbox(type);
        return this;
    }

    @Override
    public InstructionBuilder throwException(String className, String message) {
        this.check();
        this.newInstance(className).dupe().loadConstant(message);
        this.invokeConstructor(className, "java.lang.String");
        this.v.visitInsn(191);
        return this;
    }

    @Override
    public InstructionBuilder throwException(Class<? extends Throwable> exceptionType, String message) {
        this.check();
        return this.throwException(this.cache.toTypeName(exceptionType), message);
    }

    @Override
    public InstructionBuilder throwException() {
        this.check();
        this.v.visitInsn(191);
        return this;
    }

    @Override
    public InstructionBuilder startSwitch(int min, int max, SwitchCallback callback) {
        this.check();
        assert (callback != null);
        new SwitchBlockImpl(this, this.state, min, max).doCallback(callback);
        return this;
    }

    @Override
    public InstructionBuilder startVariable(String type, LocalVariableCallback callback) {
        this.check();
        LocalVariable var = this.state.startVariable(type);
        callback.doBuild(var, this);
        this.state.stopVariable(var);
        return this;
    }

    @Override
    public InstructionBuilder storeVariable(LocalVariable var) {
        this.check();
        this.state.store(var);
        return this;
    }

    @Override
    public InstructionBuilder loadVariable(LocalVariable var) {
        this.check();
        this.state.load(var);
        return this;
    }

    @Override
    public InstructionBuilder when(Condition condition, final InstructionBuilderCallback ifTrue) {
        this.check();
        assert (ifTrue != null);
        return this.when(condition, new WhenCallback(){

            @Override
            public void ifTrue(InstructionBuilder builder) {
                ifTrue.doBuild(builder);
            }

            @Override
            public void ifFalse(InstructionBuilder builder) {
            }
        });
    }

    @Override
    public InstructionBuilder when(Condition condition, WhenCallback callback) {
        this.check();
        assert (condition != null);
        assert (callback != null);
        Label ifFalseLabel = new Label();
        Label endIfLabel = new Label();
        this.v.visitJumpInsn(conditionToOpcode.get((Object)condition), ifFalseLabel);
        callback.ifTrue(this);
        this.v.visitJumpInsn(167, endIfLabel);
        this.v.visitLabel(ifFalseLabel);
        callback.ifFalse(this);
        this.v.visitLabel(endIfLabel);
        return this;
    }

    @Override
    public InstructionBuilder doWhile(Condition condition, WhileCallback callback) {
        this.check();
        assert (condition != null);
        assert (callback != null);
        Label doCheck = this.state.newLabel();
        Label exitLoop = new Label();
        callback.buildTest(this);
        this.v.visitJumpInsn(conditionToOpcode.get((Object)condition), exitLoop);
        callback.buildBody(this);
        this.v.visitJumpInsn(167, doCheck);
        this.v.visitLabel(exitLoop);
        return this;
    }

    @Override
    public InstructionBuilder increment(LocalVariable variable) {
        this.check();
        InstructionBuilderState.LVInfo info = this.state.locals.get(variable);
        this.v.visitIincInsn(info.offset, 1);
        return this;
    }

    @Override
    public InstructionBuilder arrayLength() {
        this.check();
        this.v.visitInsn(190);
        return this;
    }

    @Override
    public InstructionBuilder iterateArray(final InstructionBuilderCallback callback) {
        this.startVariable("int", new LocalVariableCallback(){

            @Override
            public void doBuild(final LocalVariable indexVariable, InstructionBuilder builder) {
                builder.loadConstant(0).storeVariable(indexVariable);
                builder.doWhile(Condition.LESS_THAN, new WhileCallback(){

                    @Override
                    public void buildTest(InstructionBuilder builder) {
                        builder.dupe().arrayLength();
                        builder.loadVariable(indexVariable).swap();
                    }

                    @Override
                    public void buildBody(InstructionBuilder builder) {
                        builder.dupe().loadVariable(indexVariable).loadArrayElement();
                        callback.doBuild(builder);
                        builder.increment(indexVariable);
                    }
                });
            }
        });
        return this;
    }

    @Override
    public InstructionBuilder dupeWide() {
        this.check();
        this.v.visitInsn(92);
        return this;
    }

    @Override
    public InstructionBuilder popWide() {
        this.check();
        this.v.visitInsn(88);
        return this;
    }

    @Override
    public InstructionBuilder compareSpecial(String typeName) {
        this.check();
        Integer opcode = typeToSpecialComparisonOpcode.get(typeName);
        if (opcode == null) {
            throw new IllegalArgumentException(String.format("Not a special primitive type: '%s'.", typeName));
        }
        this.v.visitInsn(opcode);
        return this;
    }

    void doCallback(InstructionBuilderCallback callback) {
        this.check();
        if (callback != null) {
            callback.doBuild(this);
        }
        this.lock();
    }

    static {
        Map<Object, Integer> m = conditionToOpcode;
        m.put((Object)Condition.NULL, 199);
        m.put((Object)Condition.NON_NULL, 198);
        m.put((Object)Condition.ZERO, 154);
        m.put((Object)Condition.NON_ZERO, 153);
        m.put((Object)Condition.EQUAL, 160);
        m.put((Object)Condition.NOT_EQUAL, 159);
        m.put((Object)Condition.LESS_THAN, 162);
        m.put((Object)Condition.GREATER, 164);
        typeToSpecialComparisonOpcode = new HashMap<String, Integer>();
        m = typeToSpecialComparisonOpcode;
        m.put((Object)((Condition)((Object)"long")), 148);
        m.put("float", 149);
        m.put("double", 151);
        constantOpcodes = new HashMap<Object, Integer>();
        m = constantOpcodes;
        m.put(-1, 2);
        m.put(0, 3);
        m.put(1, 4);
        m.put(2, 5);
        m.put(3, 6);
        m.put(4, 7);
        m.put(5, 8);
        m.put(0L, 9);
        m.put(1L, 10);
        m.put(Float.valueOf(0.0f), 11);
        m.put(Float.valueOf(1.0f), 12);
        m.put(Float.valueOf(2.0f), 13);
        m.put(0.0, 14);
        m.put(1.0, 15);
        m.put(null, 1);
    }
}

