(function() {
  define(["https://cdn.jsdelivr.net/npm/@hpcc-js/wasm/dist/graphviz.umd.js"], function(hpccWasm) {
    var render;
    render = function(value, id, showDownloadLink) {
      return hpccWasm.Graphviz.load().then(function(graphviz) {
        var div, layout, link, svg;
        svg = graphviz.dot(value);
        div = document.getElementById(id);
        layout = graphviz.layout(value, "svg", "dot");
        div.innerHTML = layout;
        if (showDownloadLink) {
          link = document.getElementById(id + "-download");
          return link.setAttribute("href", "data:image/svg+xml;charset=utf-8," + encodeURIComponent(layout));
        }
      });
    };
    return render;
  });

}).call(this);
