/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Method;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;

public class MethodInvocationBundle {
    public final String className;
    public final MethodDescription methodDescription;
    public final MethodAdvice[] advice;
    private volatile Method method;

    public MethodInvocationBundle(String className, MethodDescription methodDescription, MethodAdvice[] advice) {
        this.className = className;
        this.methodDescription = methodDescription;
        this.advice = advice;
    }

    public Method getMethod(Object instance) {
        if (this.method == null) {
            this.method = this.findMethod(instance.getClass().getClassLoader());
        }
        return this.method;
    }

    private Method findMethod(ClassLoader loader) {
        try {
            Class[] types = new Class[this.methodDescription.argumentTypes.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = PlasticInternalUtils.toClass(loader, this.methodDescription.argumentTypes[i]);
            }
            Class clazz = PlasticInternalUtils.toClass(loader, this.className);
            return clazz.getDeclaredMethod(this.methodDescription.methodName, types);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to locate Method %s: %s", this.methodDescription, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }
}

