/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;
import org.apache.tapestry5.plastic.PlasticUtils;

public class PlasticClassLoader
extends ClassLoader {
    private final ClassLoaderDelegate delegate;
    private Predicate<String> filter;
    private Function<String, Class<?>> alternativeClassloading;
    private String tag;
    private Map<String, Class<?>> cache;
    private static List<String> log;

    public PlasticClassLoader(ClassLoader parent, ClassLoaderDelegate delegate) {
        super(parent);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return loadedClass;
            }
            if (this.shouldInterceptClassLoading(name)) {
                Class<?> c = this.getFromCache(name);
                if (c == null) {
                    if (this.filter != null && this.filter.test(name) || this.filter == null && this.delegate.shouldInterceptClassLoading(name)) {
                        c = this.delegate.loadAndTransformClass(name);
                    } else if (this.alternativeClassloading != null) {
                        c = this.alternativeClassloading.apply(name);
                    }
                    if (this.cache != null && c != null) {
                        this.cache.put(name, c);
                    }
                }
                if (c == null) {
                    return super.loadClass(name, resolve);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }

    private boolean shouldInterceptClassLoading(String name) {
        return this.delegate.shouldInterceptClassLoading(PlasticUtils.getEnclosingClassName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> defineClassWithBytecode(String className, byte[] bytecode) {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            return this.defineClass(className, bytecode, 0, bytecode.length);
        }
    }

    public void setAlternativeClassloading(Function<String, Class<?>> alternateClassloading) {
        this.alternativeClassloading = alternateClassloading;
    }

    public void setTag(String tag) {
        this.tag = tag;
        if (this.cache == null) {
            this.cache = Collections.synchronizedMap(new HashMap());
        }
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public String toString() {
        String id = this.getClassLoaderId();
        return String.format("PlasticClassLoader[%s, tag=%s, parent=%s]", id, this.tag, this.getParent());
    }

    public String getClassLoaderId() {
        String superToString = super.toString();
        return superToString.substring(superToString.indexOf(64)).trim();
    }

    private Class<?> getFromCache(String name) {
        Class<?> c = null;
        if (this.cache != null && this.cache.containsKey(name)) {
            c = this.cache.get(name);
        }
        if (c == null && this.getParent() instanceof PlasticClassLoader) {
            c = ((PlasticClassLoader)this.getParent()).getFromCache(name);
        }
        return c;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        log = new ArrayList<String>();
    }
}

