/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);
    private static final String RESOURCE_METHOD = "org.apache.cxf.resource.method";
    private static final String RESOURCE_OPERATION_NAME = "org.apache.cxf.resource.operation.name";

    public JAXRSInInterceptor() {
        super("unmarshal");
    }

    @Override
    public void handleMessage(Message message) {
        Exchange exchange = message.getExchange();
        exchange.put("org.apache.cxf.rest.message", Boolean.TRUE);
        Response response = exchange.get(Response.class);
        if (response == null) {
            try {
                this.processRequest(message, exchange);
                if (exchange.isOneWay()) {
                    ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
                }
            }
            catch (Fault ex) {
                this.convertExceptionToResponseIfPossible(ex.getCause(), message);
            }
            catch (RuntimeException ex) {
                this.convertExceptionToResponseIfPossible(ex, message);
            }
            catch (IOException ex) {
                this.convertExceptionToResponseIfPossible(ex, message);
            }
        }
        if ((response = exchange.get(Response.class)) != null) {
            this.createOutMessage(message, response);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    private void processRequest(Message message, Exchange exchange) throws IOException {
        OperationResourceInfo ori;
        List<MediaType> acceptContentTypes;
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(message);
        RequestPreprocessor rp = providerFactory.getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
        }
        if (JAXRSUtils.runContainerRequestFilters(providerFactory, message, true, null)) {
            return;
        }
        String httpMethod = HttpUtils.getProtocolHeader(message, "org.apache.cxf.request.method", "POST", true);
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Map protocolHeaders = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        String requestContentType = null;
        List ctHeaderValues = (List)protocolHeaders.get("Content-Type");
        if (ctHeaderValues != null && !ctHeaderValues.isEmpty()) {
            requestContentType = (String)ctHeaderValues.get(0);
            message.put("Content-Type", requestContentType);
        }
        if (requestContentType == null && (requestContentType = (String)message.get("Content-Type")) == null) {
            requestContentType = "*/*";
        }
        String acceptTypes = null;
        List acceptHeaderValues = (List)protocolHeaders.get("Accept");
        if (acceptHeaderValues != null && !acceptHeaderValues.isEmpty()) {
            acceptTypes = (String)acceptHeaderValues.get(0);
            message.put("Accept", acceptTypes);
        }
        if (acceptTypes == null && (acceptTypes = HttpUtils.getProtocolHeader(message, "Accept", null)) == null) {
            acceptTypes = "*/*";
            message.put("Accept", acceptTypes);
        }
        try {
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes, "q");
        }
        catch (IllegalArgumentException ex) {
            throw ExceptionUtils.toNotAcceptableException(null, null);
        }
        exchange.put("Accept", acceptContentTypes);
        List<ClassResourceInfo> resources = JAXRSUtils.getRootResources(message);
        Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources = JAXRSUtils.selectResourceClass(resources, rawPath, message);
        if (matchedResources == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, message.get("org.apache.cxf.request.uri"), rawPath);
            Level logLevel = JAXRSUtils.getExceptionLogLevel(message, NotFoundException.class);
            LOG.log(logLevel == null ? Level.FINE : logLevel, errorMsg.toString());
            Response resp = JAXRSUtils.createResponse(resources, message, errorMsg.toString(), Response.Status.NOT_FOUND.getStatusCode(), false);
            throw ExceptionUtils.toNotFoundException(null, resp);
        }
        MetadataMap<String, String> matchedValues = new MetadataMap<String, String>();
        try {
            ori = JAXRSUtils.findTargetMethod(matchedResources, message, httpMethod, matchedValues, requestContentType, acceptContentTypes, true, true);
            this.setExchangeProperties(message, exchange, ori, matchedValues, resources.size());
        }
        catch (WebApplicationException ex) {
            if (JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), httpMethod)) {
                Response response = JAXRSUtils.createResponse(resources, null, null, 200, true);
                exchange.put(Response.class, response);
                return;
            }
            throw ex;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Request path is: " + rawPath);
            LOG.fine("Request HTTP method is: " + httpMethod);
            LOG.fine("Request contentType is: " + requestContentType);
            LOG.fine("Accept contentType is: " + acceptTypes);
            LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
        }
        if (!ori.isSubResourceLocator() && JAXRSUtils.runContainerRequestFilters(providerFactory, message, false, ori.getNameBindings())) {
            return;
        }
        List<Object> params = JAXRSUtils.processParameters(ori, matchedValues, message);
        message.setContent(List.class, params);
    }

    private void convertExceptionToResponseIfPossible(Throwable ex, Message message) {
        Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        if (excResponse == null) {
            ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
            message.getExchange().put(Message.PROPOGATE_EXCEPTION, ExceptionUtils.propogateException(message));
            throw ex instanceof RuntimeException ? (RuntimeException)ex : ExceptionUtils.toInternalServerErrorException(ex, null);
        }
        message.getExchange().put(Response.class, excResponse);
        message.getExchange().put(Throwable.class, ex);
    }

    private void setExchangeProperties(Message message, Exchange exchange, OperationResourceInfo ori, MultivaluedMap<String, String> values, int numberOfResources) {
        ResourceProvider rp;
        ClassResourceInfo cri = ori.getClassResourceInfo();
        exchange.put(OperationResourceInfo.class, ori);
        exchange.put("root.resource.class", cri);
        message.put(RESOURCE_METHOD, ori.getMethodToInvoke());
        message.put("jaxrs.template.parameters", values);
        String uriTemplate = JAXRSUtils.getUriTemplate(message, cri, ori);
        message.put("jaxrs.template.uri", uriTemplate);
        if (HttpUtils.isHttpRequest(message)) {
            HttpUtils.setHttpRequestURI(message, uriTemplate);
        }
        String plainOperationName = ori.getMethodToInvoke().getName();
        if (numberOfResources > 1) {
            plainOperationName = cri.getServiceClass().getSimpleName() + "#" + plainOperationName;
        }
        exchange.put(RESOURCE_OPERATION_NAME, plainOperationName);
        if (ori.isOneway() || PropertyUtils.isTrue(HttpUtils.getProtocolHeader(message, "OnewayRequest", null))) {
            exchange.setOneWay(true);
        }
        if ((rp = cri.getResourceProvider()) instanceof SingletonResourceProvider) {
            exchange.put("org.apache.cxf.service.object", rp.getInstance(message));
        }
    }

    private Message createOutMessage(Message inMessage, Response r) {
        Endpoint e = inMessage.getExchange().getEndpoint();
        Message mout = e.getBinding().createMessage();
        mout.setContent(List.class, new MessageContentsList(r));
        mout.setExchange(inMessage.getExchange());
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain(inMessage.getExchange()));
        inMessage.getExchange().setOutMessage(mout);
        if (r.getStatus() >= Response.Status.BAD_REQUEST.getStatusCode()) {
            inMessage.getExchange().put("cxf.io.cacheinput", Boolean.FALSE);
        }
        return mout;
    }
}

