/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.ThreadLocalQuerylessTestRunner;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DefaultConnectionTester
extends AbstractConnectionTester {
    private static final String PROP_KEY = "com.mchange.v2.c3p0.impl.DefaultConnectionTester.querylessTestRunner";
    private static final String IS_VALID_TIMEOUT_KEY = "com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout";
    static final MLogger logger;
    static final int IS_VALID_TIMEOUT;
    static final String CONNECTION_TESTING_URL = "http://www.mchange.com/projects/c3p0/#configuring_connection_testing";
    static final int HASH_CODE;
    static final Set INVALID_DB_STATES;
    static final QuerylessTestRunner METADATA_TABLESEARCH;
    static final QuerylessTestRunner IS_VALID;
    static final QuerylessTestRunner SWITCH;
    static final QuerylessTestRunner THREAD_LOCAL;
    private final QuerylessTestRunner querylessTestRunner;

    public static boolean probableInvalidDb(SQLException sQLException) {
        return INVALID_DB_STATES.contains(sQLException.getSQLState());
    }

    private static QuerylessTestRunner reflectTestRunner(String string) {
        try {
            if (string.indexOf(46) >= 0) {
                return (QuerylessTestRunner)Class.forName(string).newInstance();
            }
            Field field = DefaultConnectionTester.class.getDeclaredField(string);
            return (QuerylessTestRunner)field.get(null);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Specified QuerylessTestRunner '" + string + "' could not be found or instantiated. Reverting to default 'SWITCH'", exception);
            }
            return null;
        }
    }

    public DefaultConnectionTester() {
        QuerylessTestRunner querylessTestRunner;
        QuerylessTestRunner querylessTestRunner2 = SWITCH;
        String string = C3P0Config.getMultiPropertiesConfig().getProperty(PROP_KEY);
        this.querylessTestRunner = string == null ? querylessTestRunner2 : ((querylessTestRunner = DefaultConnectionTester.reflectTestRunner(string.trim())) != null ? querylessTestRunner : querylessTestRunner2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int activeCheckConnection(Connection connection, String string, Throwable[] throwableArray) {
        int n;
        if (string == null) {
            return this.querylessTestRunner.activeCheckConnectionNoQuery(connection, throwableArray);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            n = 0;
        }
        catch (SQLException sQLException) {
            block13: {
                String string2;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception! [query=" + string + "]", sQLException);
                }
                if (throwableArray != null) {
                    throwableArray[0] = sQLException;
                }
                if (!INVALID_DB_STATES.contains(string2 = sQLException.getSQLState())) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + string2 + "' of Exception which occurred during a Connection test (test with query '" + string + "') implies that the database is invalid, and the pool should refill itself with fresh Connections.", sQLException);
                }
                int n2 = -8;
                ResultSetUtils.attemptClose(resultSet);
                StatementUtils.attemptClose(statement);
                return n2;
            }
            int n3 = -1;
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(statement);
            return n3;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            int n4 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(resultSet);
                    StatementUtils.attemptClose(statement);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(statement);
            return n4;
        }
        ResultSetUtils.attemptClose(resultSet);
        StatementUtils.attemptClose(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int statusOnException(Connection connection, Throwable throwable, String string, Throwable[] throwableArray) {
        block12: {
            block13: {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Testing a Connection in response to an Exception:", throwable);
                }
                if (!(throwable instanceof SQLException)) break block12;
                String string2 = ((SQLException)throwable).getSQLState();
                if (!INVALID_DB_STATES.contains(string2)) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + string2 + "' of Exception tested by statusOnException() implies that the database is invalid, and the pool should refill itself with fresh Connections.", throwable);
                }
                int n = -8;
                return n;
            }
            int n = this.activeCheckConnection(connection, string, throwableArray);
            return n;
        }
        try {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", throwable);
            }
            if (throwableArray != null) {
                throwableArray[0] = throwable;
            }
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            int n = -1;
            return n;
        }
    }

    private static String queryInfo(String string) {
        return string == null ? "[using Connection.isValid(...) if supported, or else traditional default query]" : "[query=" + string + "]";
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object.getClass() == DefaultConnectionTester.class;
    }

    @Override
    public int hashCode() {
        return HASH_CODE;
    }

    static {
        int n;
        block6: {
            logger = MLog.getLogger(DefaultConnectionTester.class);
            HASH_CODE = DefaultConnectionTester.class.getName().hashCode();
            METADATA_TABLESEARCH = new QuerylessTestRunner(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public int activeCheckConnectionNoQuery(Connection connection, Throwable[] throwableArray) {
                    int n;
                    ResultSet resultSet = null;
                    try {
                        resultSet = connection.getMetaData().getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
                        n = 0;
                    }
                    catch (SQLException sQLException) {
                        block12: {
                            String string;
                            if (logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Connection " + connection + " failed default system-table Connection test with an Exception!", sQLException);
                            }
                            if (throwableArray != null) {
                                throwableArray[0] = sQLException;
                            }
                            if (!INVALID_DB_STATES.contains(string = sQLException.getSQLState())) break block12;
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "SQL State '" + string + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, and the pool should refill itself with fresh Connections.", sQLException);
                            }
                            int n2 = -8;
                            ResultSetUtils.attemptClose(resultSet);
                            return n2;
                        }
                        int n3 = -1;
                        ResultSetUtils.attemptClose(resultSet);
                        return n3;
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Connection " + connection + " failed default system-table Connection test with an Exception!", exception);
                        }
                        if (throwableArray != null) {
                            throwableArray[0] = exception;
                        }
                        int n4 = -1;
                        {
                            catch (Throwable throwable) {
                                ResultSetUtils.attemptClose(resultSet);
                                throw throwable;
                            }
                        }
                        ResultSetUtils.attemptClose(resultSet);
                        return n4;
                    }
                    ResultSetUtils.attemptClose(resultSet);
                    return n;
                }
            };
            IS_VALID = new QuerylessTestRunner(){

                @Override
                public int activeCheckConnectionNoQuery(Connection connection, Throwable[] throwableArray) {
                    try {
                        boolean bl = connection.isValid(IS_VALID_TIMEOUT);
                        if (bl) {
                            return 0;
                        }
                        if (throwableArray != null) {
                            throwableArray[0] = new SQLException("Connection.isValid(" + IS_VALID_TIMEOUT + ") returned false.");
                        }
                        return -1;
                    }
                    catch (SQLException sQLException) {
                        String string;
                        if (throwableArray != null) {
                            throwableArray[0] = sQLException;
                        }
                        if (INVALID_DB_STATES.contains(string = sQLException.getSQLState())) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "SQL State '" + string + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, and the pool should refill itself with fresh Connections.", sQLException);
                            }
                            return -8;
                        }
                        return -1;
                    }
                    catch (Exception exception) {
                        if (throwableArray != null) {
                            throwableArray[0] = exception;
                        }
                        return -1;
                    }
                }
            };
            SWITCH = new QuerylessTestRunner(){

                @Override
                public int activeCheckConnectionNoQuery(Connection connection, Throwable[] throwableArray) {
                    int n;
                    try {
                        n = IS_VALID.activeCheckConnectionNoQuery(connection, throwableArray);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        n = METADATA_TABLESEARCH.activeCheckConnectionNoQuery(connection, throwableArray);
                    }
                    return n;
                }
            };
            THREAD_LOCAL = new ThreadLocalQuerylessTestRunner();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("08001");
            hashSet.add("08007");
            INVALID_DB_STATES = Collections.unmodifiableSet(hashSet);
            n = -1;
            String string = C3P0Config.getMultiPropertiesConfig().getProperty(IS_VALID_TIMEOUT_KEY);
            try {
                if (string != null) {
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "Could not parse value set for com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout ['" + string + "'] into int.", numberFormatException);
            }
        }
        if (n <= 0) {
            n = 0;
        } else if (logger.isLoggable(MLevel.INFO)) {
            logger.log(MLevel.INFO, "Connection.isValid(...) based Connection tests will timeout and fail after " + n + " seconds.");
        }
        IS_VALID_TIMEOUT = n;
    }

    public static interface QuerylessTestRunner
    extends Serializable {
        public int activeCheckConnectionNoQuery(Connection var1, Throwable[] var2);
    }
}

